/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.exceptions.CouldNotCopyDataException;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Command {
    private String commandName;
    private final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public Command(String commandName) {
        this.commandName = commandName;
    }

    protected String getCommandName() {
        return this.commandName;
    }

    public abstract void run() throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, NoSuchAlgorithmException, CouldNotHashException, IOException, InvalidHashFileException, CouldNotCopyDataException;

    protected void info(String s) {
        System.out.println(this.DF.format(new Date()) + " INFO  - " + s);
    }

    protected void error(String s) {
        System.out.println(this.DF.format(new Date()) + " ERROR - " + s);
    }

    protected void error(Throwable e) {
        System.out.print(this.DF.format(new Date()) + " ERROR - ");
        e.printStackTrace(System.out);
    }
}

