/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.DataSourceCommand;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.Identifier;
import highfive.model.Table;
import highfive.utils.Name;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ListTablesAndCheckCommand
extends DataSourceCommand {
    public ListTablesAndCheckCommand(String datasourceName) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("List Tables", datasourceName);
    }

    @Override
    public void execute() throws SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, InvalidConfigurationException {
        List<Identifier> tableNames = this.ds.getDialect().listTablesNames();
        int filterSize = this.ds.getTableFilter().size();
        this.info(" ");
        this.info("Tables found (" + tableNames.size() + (filterSize == 0 ? "" : "/" + filterSize) + "):");
        for (Identifier identifier : tableNames) {
            this.info("  " + identifier.getGenericName());
        }
        List<Name> na = this.ds.getTableFilter().listNotAccepted();
        if (!na.isEmpty()) {
            this.info("Tables not found (" + na.size() + "/" + filterSize + "):");
            for (Name n : na) {
                this.info("  " + n);
            }
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Identifier tn : tableNames) {
            Table t = this.ds.getDialect().getTableMetaData(tn);
            tables.add(t);
            for (Column c : t.getColumns()) {
                String key = c.getRenderedType() + " [" + (c.getSerializer() == null ? "N/A" : c.getSerializer().getName()) + "]";
                Integer count = (Integer)treeMap.get(key);
                count = count == null ? Integer.valueOf(1) : count + 1;
                treeMap.put(key, count);
            }
        }
        this.info(" ");
        this.info("Summary of types found (" + treeMap.size() + "):");
        for (String t : treeMap.keySet()) {
            this.info("  " + t + ": " + treeMap.get(t));
        }
        this.displayRowCount(tables);
        this.checkIfHashingAndCopyingIsSupported(tables);
    }
}

