/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.UnsupportedSQLFeatureException;
import highfive.model.DataSource;
import highfive.model.Table;
import highfive.model.TableHashingMember;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class TableHashingOrdering {
    private String tableName;
    private LinkedHashMap<String, TableHashingMember> members;

    public TableHashingOrdering(String tableName) {
        this.tableName = tableName;
        this.members = new LinkedHashMap();
    }

    public void validate(DataSource ds, Table t) throws InvalidConfigurationException {
        Set existingColumns = t.getColumns().stream().map(c -> c.getName()).collect(Collectors.toSet());
        for (String c2 : this.members.keySet()) {
            if (existingColumns.contains(c2)) continue;
            throw new InvalidConfigurationException("Invalid hashing ordering for table '" + this.tableName + "' declared in the property '" + ds.getName() + ".hashing.ordering': column '" + c2 + "' does not exist.");
        }
        for (TableHashingMember m : this.members.values()) {
            if (m.getNullsFirst() == null) continue;
            try {
                ds.getDialect().renderNullsOrdering(m.getNullsFirst());
            }
            catch (UnsupportedSQLFeatureException e) {
                throw new InvalidConfigurationException("Invalid hashing ordering for table '" + this.tableName + "' declared in the property '" + ds.getName() + ".hashing.ordering': NULLS FIRST (nf) and NULLS LAST (nl) are not supported by this database.");
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public LinkedHashMap<String, TableHashingMember> getMembers() {
        return this.members;
    }

    public boolean usesAllColumns() {
        return this.members.isEmpty();
    }
}

