/*
 * Decompiled with CFR 0.152.
 */
package highfive.serializers;

import highfive.model.Serializer;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IntegerSerializer
extends Serializer<Integer> {
    private static ByteBuffer IB = ByteBuffer.allocate(4);
    private Integer value;

    @Override
    public byte[] read(ResultSet rs, int ordinal) throws SQLException {
        this.value = rs.getInt(ordinal);
        if (rs.wasNull()) {
            this.value = null;
            return null;
        }
        IB.putInt(0, this.value);
        return IB.array();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement ps, int ordinal) throws SQLException {
        if (this.value == null) {
            ps.setNull(ordinal, 4);
        } else {
            ps.setInt(ordinal, this.value);
        }
    }
}

