/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.GenericHashCommand;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.HashFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;

public class VerifyCommand
extends GenericHashCommand {
    private String baselineFile;

    public VerifyCommand(String datasourceName, String baselineFile) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("Verify", datasourceName);
        this.baselineFile = baselineFile;
    }

    @Override
    public void execute() throws FileNotFoundException, IOException, InvalidHashFileException, NoSuchAlgorithmException, SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, CouldNotHashException, InvalidConfigurationException {
        HashFile existing = HashFile.loadFrom(this.baselineFile);
        super.hash();
        this.info(" ");
        this.info("Verifying hashes:");
        HashFile.ComparisonResult result = existing.compareTo(this.hashFile, "baseline hash file", "live database");
        for (String err : result.getErrors()) {
            this.error("  - " + err);
        }
        if (result.getErrors().isEmpty()) {
            this.info("  All data hashes match (" + result.getMatched() + " tables) -- The verification succeeded.");
        } else {
            this.error("  A total of " + result.getMatched() + " tables matched and there were " + result.getErrors().size() + " difference(s) in the hashes -- The verification failed.");
        }
    }
}

