/*
 * Decompiled with CFR 0.152.
 */
package highfive.dialects;

import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.DataSource;
import highfive.model.Dialect;
import highfive.model.Identifier;
import highfive.model.PKColumn;
import highfive.model.Serializer;
import highfive.model.Table;
import highfive.serializers.BigDecimalSerializer;
import highfive.serializers.BigIntegerSerializer;
import highfive.serializers.ByteArraySerializer;
import highfive.serializers.DoubleSerializer;
import highfive.serializers.IntegerSerializer;
import highfive.serializers.LocalDateTimeSerializer;
import highfive.serializers.LongSerializer;
import highfive.serializers.StringSerializer;
import highfive.serializers.ZonedDateTimeSerializer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OracleDialect
extends Dialect {
    public OracleDialect(DataSource ds, Connection conn) {
        super(ds, conn);
    }

    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public List<Identifier> listTablesNames() throws SQLException, InvalidSchemaException {
        ArrayList<Identifier> tables = new ArrayList<Identifier>();
        String sql = "select table_name from all_tables where owner = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, this.ds.getSchema());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String table = rs.getString(1);
                    if (rs.wasNull()) {
                        throw new InvalidSchemaException("The schema includes a table with no name.");
                    }
                    if (!this.ds.getTableFilter().accepts(table)) continue;
                    tables.add(new Identifier(table, this.ds.getRemoveTablePrefix(), this));
                }
            }
        }
        return tables;
    }

    @Override
    public Table getTableMetaData(Identifier tn) throws SQLException, UnsupportedDatabaseTypeException {
        List<PKColumn> pkColumns = this.getPrimaryKeyColumns(this.conn, this.ds.getSchema(), tn);
        Map<String, Integer> pkByName = pkColumns.stream().collect(Collectors.toMap(x -> x.getCanonicalName(), x -> x.getPosition()));
        ArrayList<Column> columns = new ArrayList<Column>();
        String sql = "select column_name, data_type, data_length, data_precision, data_scale from all_tab_columns where owner = ? and table_name = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, this.ds.getSchema());
            ps.setString(2, tn.getCanonicalName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Integer len;
                    int col = 1;
                    String name = this.readString(rs, col++);
                    if (!this.ds.getColumnFilter().accepts(name)) continue;
                    String type = this.readString(rs, col++);
                    boolean unsigned = false;
                    BigInteger length = (len = this.readInt(rs, col++)) == null ? null : BigInteger.valueOf(len.intValue());
                    Integer precision = this.readInt(rs, col++);
                    Integer scale = this.readInt(rs, col++);
                    Integer pkPosition = pkByName.get(name);
                    String renderedType = this.renderType(name, type, length, precision, scale);
                    Serializer<?> serializer = super.getSerializer(renderedType, tn, name, type, unsigned, length, precision, scale);
                    Column c = new Column(name, type, length, precision, scale, renderedType, pkPosition, serializer);
                    columns.add(c);
                }
            }
        }
        return new Table(tn, columns);
    }

    private List<PKColumn> getPrimaryKeyColumns(Connection conn, String schema, Identifier table) throws SQLException {
        ArrayList<PKColumn> pk = new ArrayList<PKColumn>();
        String sql = "select c.column_name, c.position from all_cons_columns c join all_constraints x on x.constraint_name = c.constraint_name and x.owner = c.owner where x.owner = ? and x.table_name = ? and x.constraint_type = 'P'";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, schema);
            ps.setString(2, table.getCanonicalName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = this.readString(rs, 1);
                    Integer position = this.readInt(rs, 2);
                    PKColumn pkc = new PKColumn(position, name);
                    pk.add(pkc);
                }
            }
        }
        return pk;
    }

    private String renderType(String name, String type, BigInteger length, Integer precision, Integer scale) {
        if (type == null) {
            return "N/A";
        }
        if ("CHAR".equals(type) || "VARCHAR2".equals(type) || "NCHAR".equals(type) || "NVARCHAR2".equals(type)) {
            return type + "(" + length + ")";
        }
        if ("CLOB".equals(type) || "NCLOB".equals(type)) {
            return type + "(" + length + ")";
        }
        if ("NUMBER".equals(type)) {
            if (precision == null) {
                return type;
            }
            return type + "(" + precision + ", " + scale + ")";
        }
        if ("FLOAT".equals(type) || "BINARY_FLOAT".equals(type) || "BINARY_DOUBLE".equals(type)) {
            return type;
        }
        if ("DATE".equals(type) || type.startsWith("TIMESTAMP")) {
            return type;
        }
        if ("RAW".equals(type)) {
            return type + "(" + length + ")";
        }
        if ("BLOB".equals(type) || "LONG RAW".equals(type)) {
            return type + "(" + length + ")";
        }
        if (type.startsWith("INTERVAL")) {
            return type;
        }
        return type;
    }

    @Override
    protected Serializer<?> getDefaultSerializer(Identifier table, String name, String type, boolean unsigned, BigInteger maxLength, Integer precision, Integer scale) throws UnsupportedDatabaseTypeException {
        if (type == null) {
            throw new UnsupportedDatabaseTypeException("Unsupported column type for column " + name + " in table " + table + ": " + type);
        }
        if ("CHAR".equals(type) || "VARCHAR2".equals(type) || "NCHAR".equals(type) || "NVARCHAR2".equals(type)) {
            return new StringSerializer();
        }
        if ("CLOB".equals(type) || "NCLOB".equals(type)) {
            return new StringSerializer();
        }
        if ("NUMBER".equals(type)) {
            if (precision == null) {
                return new BigIntegerSerializer();
            }
            if (scale == null | scale.equals(0)) {
                if (precision <= 9) {
                    return new IntegerSerializer();
                }
                if (precision <= 18) {
                    return new LongSerializer();
                }
                return new BigIntegerSerializer();
            }
            return new BigDecimalSerializer();
        }
        if ("FLOAT".equals(type) || "BINARY_FLOAT".equals(type) || "BINARY_DOUBLE".equals(type)) {
            return new DoubleSerializer();
        }
        if ("DATE".equals(type)) {
            return new LocalDateTimeSerializer();
        }
        if (type.matches("^TIMESTAMP\\(\\d+\\)$")) {
            return new LocalDateTimeSerializer();
        }
        if (type.matches("^TIMESTAMP\\(\\d+\\) WITH TIME ZONE$")) {
            return new ZonedDateTimeSerializer();
        }
        if (type.matches("^TIMESTAMP\\(\\d+\\) WITH LOCAL TIME ZONE$")) {
            return new ZonedDateTimeSerializer();
        }
        if ("RAW".equals(type) || "BLOB".equals(type) || "LONG RAW".equals(type)) {
            return new ByteArraySerializer();
        }
        return null;
    }

    private String readString(ResultSet rs, int ordinal) throws SQLException {
        String v = rs.getString(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private Integer readInt(ResultSet rs, int ordinal) throws SQLException {
        Integer v = rs.getInt(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private <T> T readObject(ResultSet rs, int ordinal, Class<T> cls) throws SQLException {
        T v = rs.getObject(ordinal, cls);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    @Override
    public String escapeIdentifierAsNeeded(String canonicalName) {
        if (canonicalName.matches("^[A-Z0-9_]+$")) {
            return canonicalName;
        }
        return "\"" + canonicalName.replace("\"", "\"\"") + "\"";
    }

    @Override
    public String addCollation(String columnCanonicalName, String collation) {
        return columnCanonicalName + " collate " + collation;
    }

    @Override
    public String renderSQLTableIdentifier(Identifier table) {
        return (this.ds.getSchema() == null ? "" : this.escapeIdentifierAsNeeded(this.ds.getSchema()) + ".") + table.renderSQL();
    }

    @Override
    public String renderHeadLimit(Long limit) {
        return "";
    }

    @Override
    public String renderTailLimit(Long limit) {
        return limit == null ? "" : " fetch next " + limit + " rows only";
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return true;
    }

    @Override
    public String renderNullsOrdering(boolean nullsFirst) {
        return nullsFirst ? " nulls first" : " nulls last";
    }
}

