/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.model.OptionalProperty;
import highfive.utils.Name;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TableFilter
implements OptionalProperty {
    private List<Name> allowedTables;
    private List<Name> acceptedTables;

    public TableFilter(Set<String> allowedTables) {
        this.allowedTables = allowedTables == null || allowedTables.isEmpty() ? null : allowedTables.stream().map(n -> Name.of(n)).collect(Collectors.toList());
        this.reset();
    }

    public void reset() {
        this.acceptedTables = new ArrayList<Name>();
    }

    public boolean allTablesFound() {
        return this.allowedTables == null || this.acceptedTables.size() >= this.allowedTables.size();
    }

    public int found() {
        return this.acceptedTables.size();
    }

    public boolean accepts(String canonicalName) {
        if (this.allowedTables == null) {
            return true;
        }
        if (canonicalName == null) {
            return false;
        }
        String genericName = canonicalName.toLowerCase();
        for (Name name : this.allowedTables) {
            if (name.isQuoted()) {
                if (!canonicalName.equals(name.getName())) continue;
                this.acceptedTables.add(name);
                return true;
            }
            if (!genericName.equals(name.getName())) continue;
            this.acceptedTables.add(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean declared() {
        return this.allowedTables != null;
    }

    public int size() {
        return this.allowedTables == null ? 0 : this.allowedTables.size();
    }

    public List<Name> listNotAccepted() {
        if (this.allowedTables == null) {
            return new ArrayList<Name>();
        }
        ArrayList<Name> diff = new ArrayList<Name>(this.allowedTables);
        diff.removeAll(this.acceptedTables);
        return diff;
    }

    public String render() {
        return this.allowedTables == null ? "" : this.allowedTables.stream().map(n -> n.toString()).collect(Collectors.joining(","));
    }
}

