/*
 * Decompiled with CFR 0.152.
 */
package highfive;

import highfive.commands.Command;
import highfive.commands.CopyCommand;
import highfive.commands.HashCommand;
import highfive.commands.HashCompareCommand;
import highfive.commands.HashDumpCommand;
import highfive.commands.HashDupesCommand;
import highfive.commands.HashLoggingCommand;
import highfive.commands.ListColumnsAndCheckCommand;
import highfive.commands.ListTablesAndCheckCommand;
import highfive.commands.VerifyCommand;
import highfive.exceptions.ApplicationException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.utils.JULCustomFormatter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public class HighFive {
    private static final SimpleDateFormat DF;

    public static void main(String[] args) {
        try {
            HighFive.processCommand(args);
        }
        catch (Throwable e) {
            HighFive.error(e);
            System.exit(1);
        }
    }

    private static void processCommand(String[] args) {
        try {
            if (args.length == 2 && "listtables".equals(args[0])) {
                ListTablesAndCheckCommand c = new ListTablesAndCheckCommand(args[1]);
                try {
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error(e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 2 && "listcolumns".equals(args[0])) {
                ListColumnsAndCheckCommand c = new ListColumnsAndCheckCommand(args[1]);
                try {
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error(e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 2 && "hash".equals(args[0])) {
                try {
                    HashCommand c = new HashCommand(args[1]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not hash data: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 2 && "hashdupes".equals(args[0])) {
                try {
                    HashDupesCommand c = new HashDupesCommand(args[1]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not search for hash dupes: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 3 && "hashd".equals(args[0])) {
                System.out.println("D1");
                try {
                    HashDumpCommand.HashDumpConfig config = HashDumpCommand.HashDumpConfig.of(args[2]);
                    HashDumpCommand c = new HashDumpCommand(args[1], config);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not generate the hashdump: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 5 && "hashd".equals(args[0])) {
                System.out.println("D2");
                try {
                    HashDumpCommand.HashDumpConfig config = HashDumpCommand.HashDumpConfig.of(args[2], args[3], args[4]);
                    HashDumpCommand c = new HashDumpCommand(args[1], config);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not generate the hashdump: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 6 && "hashd".equals(args[0])) {
                System.out.println("D3");
                try {
                    HashDumpCommand.HashDumpConfig config = HashDumpCommand.HashDumpConfig.of(args[2], args[3], args[4], args[5]);
                    HashDumpCommand c = new HashDumpCommand(args[1], config);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not generate the hashdump: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 4 && "hashc".equals(args[0])) {
                try {
                    HashDumpCommand.HashDumpConfig config = HashDumpCommand.HashDumpConfig.forCompare(args[2], args[3]);
                    HashCompareCommand c = new HashCompareCommand(args[1], config);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not generate the hashdump: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 5 && "hashl".equals(args[0])) {
                try {
                    HashDumpCommand.HashDumpConfig config = HashDumpCommand.HashDumpConfig.forLog(args[2], args[3], args[4]);
                    HashLoggingCommand c = new HashLoggingCommand(args[1], config);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not generate the hashdump: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 3 && "verify".equals(args[0])) {
                try {
                    VerifyCommand c = new VerifyCommand(args[1], args[2]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not verify data: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 3 && "copy".equals(args[0])) {
                try {
                    CopyCommand c = new CopyCommand(args[1], args[2]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not copy data: " + e.getMessage());
                    System.exit(1);
                }
            } else {
                if (args.length == 0) {
                    HighFive.error("The command was not found or the incorrect number of parameters was specified.");
                } else {
                    HighFive.error("Invalid command: " + args[0]);
                }
                HighFive.info("Usage: java -jar highfive.jar listtables <datasource>");
                HighFive.info("       java -jar highfive.jar listcolumns <datasource>");
                HighFive.info("       java -jar highfive.jar copy <from-datasource> <to-datasource>");
                HighFive.info("       java -jar highfive.jar hash <datasource>");
                HighFive.info("       java -jar highfive.jar verify <datasource> <baseline-hash-file>");
                HighFive.info("       java -jar highfive.jar hashd <datasource> <table> [<start> <end> [<step>]]");
                HighFive.info("       java -jar highfive.jar hashc <datasource> <table> <baseline-dump-file>");
                HighFive.info("       java -jar highfive.jar hashl <datasource> <table> <start> <end>");
                System.exit(1);
            }
        }
        catch (InvalidConfigurationException | UnsupportedDatabaseTypeException | IOException | NoSuchAlgorithmException | SQLException e) {
            HighFive.error(e);
            System.exit(1);
        }
        catch (RuntimeException e) {
            HighFive.error(e);
            System.exit(1);
        }
    }

    private static void info(String s) {
        System.out.println(DF.format(new Date()) + " INFO  - " + s);
    }

    private static void error(String s) {
        System.out.println(DF.format(new Date()) + " ERROR - " + s);
    }

    private static void error(Throwable e) {
        System.out.print(DF.format(new Date()) + " ERROR - ");
        e.printStackTrace(System.out);
    }

    static {
        JULCustomFormatter.initialize(Level.INFO);
        DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

