/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.DataSourceCommand;
import highfive.commands.consumer.HashConsumer;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.exceptions.UnsupportedSQLFeatureException;
import highfive.model.Column;
import highfive.model.Hasher;
import highfive.model.Identifier;
import highfive.model.Table;
import highfive.model.TableHashingMember;
import highfive.model.TableHashingOrdering;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class GenericHashCommand
extends DataSourceCommand {
    private static final int MAX_ORDERING_ERRORS = 3;

    public GenericHashCommand(String commandName, String datasourceName) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super(commandName, datasourceName);
    }

    protected void hashOneSchema(HashConsumer hc) throws SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, CouldNotHashException, NoSuchAlgorithmException, InvalidHashFileException, InvalidConfigurationException, IOException {
        List<Identifier> tableNames = this.ds.getDialect().listTablesNames();
        if (!this.ds.getTableFilter().allTablesFound()) {
            throw new CouldNotHashException("Could not find the following tables declared in the property '" + this.ds.getName() + ".table.filter': " + this.ds.getTableFilter().listNotAccepted().stream().map(n -> n.toString()).collect(Collectors.joining(", ")));
        }
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Identifier tn : tableNames) {
            Table t = this.ds.getDialect().getTableMetaData(tn);
            tables.add(t);
            String ro = this.renderOrdering(t);
            if (ro != null) continue;
            throw new CouldNotHashException("  - Table " + tn.getCanonicalName() + " does not have a sorting order for hashing. " + "Add a primary key or declare a unique criteria for ordering using the property '" + this.ds.getName() + ".hashing.ordering'.");
        }
        this.displayRowCount(tables);
        this.checkIfHashingAndCopyingIsSupported(tables);
        this.info(" ");
        this.info("Hashing:");
        int cnt = 1;
        for (Table t : tables) {
            this.hashOneTable(t, hc, cnt, tables.size());
            ++cnt;
        }
        this.info("  Data hashes generated to: " + this.ds.getHashFileName());
    }

    protected Identifier findTable(String tableName, List<Identifier> tableNames) {
        for (Identifier tn : tableNames) {
            if (!tn.getGenericName().equals(tableName)) continue;
            return tn;
        }
        return null;
    }

    protected void hashOneTable(Table t, HashConsumer consumer) throws CouldNotHashException, NoSuchAlgorithmException, SQLException {
        this.hashOneTable(t, consumer, null, null);
    }

    protected void hashOneTable(Table t, HashConsumer consumer, Integer cnt, Integer total) throws CouldNotHashException, NoSuchAlgorithmException, SQLException {
        Identifier tn = t.getIdentifier();
        if (cnt == null) {
            this.info("  Hashing table: " + tn.renderSQL());
        } else {
            this.info("  Hashing table (" + cnt + "/" + total + "): " + tn.renderSQL());
        }
        String names = t.getColumns().stream().map(c -> this.ds.getDialect().escapeIdentifierAsNeeded(c.getCanonicalName())).collect(Collectors.joining(", "));
        String selectOrdering = this.renderOrdering(t);
        RowComparator rowComparator = this.getRowComparator(t);
        String tid = this.ds.getDialect().renderSQLTableIdentifier(tn);
        String sql = "select" + this.ds.getDialect().renderHeadLimit(this.ds.getMaxRows()) + " " + names + " from " + tid + " order by " + selectOrdering + this.ds.getDialect().renderTailLimit(this.ds.getMaxRows());
        if (this.ds.getLogSQL()) {
            this.info("    * sql: " + sql);
        }
        Hasher h = new Hasher();
        consumer.initializeHasher(h);
        this.ds.getConnection().setAutoCommit(true);
        this.ds.getConnection().setAutoCommit(this.ds.getSelectAutoCommit());
        int row = 0;
        int orderingErrors = 0;
        boolean tableConsumed = false;
        try (PreparedStatement ps = this.ds.getConnection().prepareStatement(sql, 1003, 1007);){
            if (this.ds.getSelectFetchSize() != null) {
                ps.setFetchSize(this.ds.getSelectFetchSize());
            }
            try (ResultSet rs = ps.executeQuery();){
                int logCount = 0;
                row = 0;
                orderingErrors = 0;
                boolean active = true;
                while (rs.next() && active) {
                    ++row;
                    if (++logCount >= 100000) {
                        this.info("    " + DF.format(row) + " rows read");
                        logCount = 0;
                    }
                    consumer.consumeValueHeader(row);
                    int col = 1;
                    byte[] bytes = null;
                    for (Column c2 : t.getColumns()) {
                        try {
                            bytes = c2.getSerializer().read(rs, col);
                            Object v = c2.getSerializer().getValue();
                            rowComparator.setColumn(col, v);
                        }
                        catch (SQLException e) {
                            this.error("The JDBC driver could not read the value of column '" + c2.getCanonicalName() + "' on table '" + tn.getCanonicalName() + "' as a '" + c2.getSerializer().getName() + "' value. The error happened in row #" + DF.format(row) + " when the table is sorted by the columns: " + selectOrdering + ".");
                            throw e;
                        }
                        catch (RuntimeException e) {
                            this.error("Could not serialize the value for column '" + c2.getCanonicalName() + "' on table '" + tn.getCanonicalName() + "'. The error happened in row #" + DF.format(row) + " when the table is sorted by the columns: " + selectOrdering + ". Is '" + c2.getSerializer().getClass().getSimpleName() + "' the correct serializer for this column?");
                            throw e;
                        }
                        h.apply(bytes);
                        consumer.consumeValue(row, c2, bytes, h);
                        ++col;
                    }
                    if (this.ds.getMaxRows() != null && (long)row >= this.ds.getMaxRows()) {
                        this.info("    - Limit of " + this.ds.getMaxRows() + " rows (max.rows) reached when reading this table -- moving on to the next table.");
                        break;
                    }
                    boolean hasValidOrdering = rowComparator.hasValidOrdering();
                    if (!hasValidOrdering && ++orderingErrors <= 3) {
                        this.error("Non-deterministic hashing ordering found in table '" + tn.getCanonicalName() + "' (#" + orderingErrors + "); found at least two rows with the same value in the ordering columns (" + rowComparator.getOrderingColumns().stream().collect(Collectors.joining(", ")) + "), but different values in the rest of the columns:");
                        this.error(" * Previous row: " + rowComparator.renderPreviousRow());
                        this.error(" * Current row: " + rowComparator.renderCurrentRow());
                    }
                    rowComparator.next();
                    active = consumer.consumeRow(row, h);
                }
                if (orderingErrors > 0) {
                    this.error("The hashing computation won't be predictable for the table '" + tn.getCanonicalName() + "' and can result in false positives or false negatives.");
                }
                if (orderingErrors > 3) {
                    this.error("A total of " + orderingErrors + " non-deterministic hashing ordering issues were found in table '" + tn.getCanonicalName() + "'; only the first " + 3 + " were displayed.");
                }
                consumer.consumeTable(t.getIdentifier().getGenericName(), orderingErrors > 0, false, row);
                tableConsumed = true;
                this.info("    " + DF.format(row) + " row(s) read");
            }
            catch (Throwable e) {
                e.printStackTrace(System.out);
                this.info("tableConsumed=" + tableConsumed);
                if (!tableConsumed) {
                    try {
                        consumer.consumeTable(t.getIdentifier().getGenericName(), orderingErrors > 0, true, row);
                    }
                    catch (InvalidHashFileException e1) {
                        this.error("Could not save hash for table '" + t.getIdentifier().getGenericName() + "'.");
                        e.printStackTrace(System.out);
                    }
                }
                this.info("    Failed to read table " + tn.getGenericName() + " -- skipped");
            }
        }
    }

    private String renderOrdering(Table t) throws CouldNotHashException {
        String selectOrdering = null;
        TableHashingOrdering tho = this.ds.getHashingOrderings().get(t.getIdentifier().getGenericName());
        if (tho != null) {
            try {
                tho.validate(this.ds, t);
            }
            catch (InvalidConfigurationException e) {
                throw new CouldNotHashException(e.getMessage());
            }
            Collection<TableHashingMember> thms = tho.getMembers().values();
            if (thms.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Column c : t.getColumns()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    String cm = this.ds.getDialect().escapeIdentifierAsNeeded(c.getCanonicalName());
                    if (c.getSerializer().canUseACollation() && this.ds.getHashingCollation() != null) {
                        cm = this.ds.getDialect().addCollation(cm, this.ds.getHashingCollation());
                    }
                    sb.append(cm);
                }
                selectOrdering = sb.toString();
            } else {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (TableHashingMember m : thms) {
                    Column col = t.findColumn(m.getGenericColumnName());
                    if (col == null) {
                        throw new CouldNotHashException("Could not find column '" + m.getGenericColumnName() + "' specified in the hashing ordering in the table '" + t.getIdentifier().getCanonicalName() + "'.");
                    }
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    String cm = this.ds.getDialect().escapeIdentifierAsNeeded(m.getGenericColumnName());
                    if (col.getSerializer().canUseACollation() && this.ds.getHashingCollation() != null) {
                        cm = this.ds.getDialect().addCollation(cm, this.ds.getHashingCollation());
                    }
                    sb.append(cm);
                    if (!m.isAscending()) {
                        sb.append(" desc");
                    }
                    if (m.getNullsFirst() == null) continue;
                    try {
                        sb.append(this.ds.getDialect().renderNullsOrdering(m.getNullsFirst()));
                    }
                    catch (UnsupportedSQLFeatureException e) {
                        throw new CouldNotHashException("The schema is not supported since the table '" + t.getIdentifier().getGenericName() + "' ordering includes NULLS FIRST or NULLS LAST and this is not supported by this database.");
                    }
                }
                selectOrdering = sb.toString();
            }
        } else {
            List<Column> pkColumns = t.getPKColumns();
            if (pkColumns.isEmpty()) {
                throw new CouldNotHashException("The schema is not supported since the table '" + t.getIdentifier().getGenericName() + "' has no primary key and no hashing ordering was declared using the property '" + this.ds.getName() + ".hashing.ordering'.");
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Column c : pkColumns) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                String cm = this.ds.getDialect().escapeIdentifierAsNeeded(c.getCanonicalName());
                if (c.getSerializer().canUseACollation() && this.ds.getHashingCollation() != null) {
                    cm = this.ds.getDialect().addCollation(cm, this.ds.getHashingCollation());
                }
                sb.append(cm);
            }
            selectOrdering = sb.toString();
        }
        return selectOrdering;
    }

    private RowComparator getRowComparator(Table t) {
        List<Object> orderingColumnsOrdinals;
        HashMap<String, Integer> ordinals = new HashMap<String, Integer>();
        int ordinal = 1;
        for (Column c2 : t.getColumns()) {
            ordinals.put(c2.getCanonicalName(), ordinal);
            ++ordinal;
        }
        List<String> columnNames = t.getColumns().stream().map(c -> c.getName()).collect(Collectors.toList());
        TableHashingOrdering tho = this.ds.getHashingOrderings().get(t.getIdentifier().getGenericName());
        if (tho == null) {
            orderingColumnsOrdinals = t.getColumns().stream().filter(c -> c.getPKPosition() != null).map(c -> (Integer)ordinals.get(c.getCanonicalName())).collect(Collectors.toList());
        } else {
            Collection<TableHashingMember> thms = tho.getMembers().values();
            if (thms.isEmpty()) {
                orderingColumnsOrdinals = IntStream.range(1, t.getColumns().size() + 1).boxed().collect(Collectors.toList());
            } else {
                orderingColumnsOrdinals = new ArrayList();
                for (TableHashingMember m : thms) {
                    Column col = t.findColumn(m.getGenericColumnName());
                    orderingColumnsOrdinals.add(ordinals.get(col.getCanonicalName()));
                }
            }
        }
        return new RowComparator(columnNames, orderingColumnsOrdinals);
    }

    private static class RowComparator {
        private int numberOfColumns;
        private String[] columnNames;
        private boolean firstRow;
        private boolean[] usedForOrdering;
        private String[] previousRow;
        private String[] currentRow;
        private List<String> orderingColumns;

        public RowComparator(List<String> columnNames, List<Integer> orderingColumnsOrdinals) {
            this.numberOfColumns = columnNames.size();
            this.columnNames = columnNames.toArray(new String[0]);
            this.firstRow = true;
            this.usedForOrdering = new boolean[this.numberOfColumns];
            this.previousRow = new String[this.numberOfColumns];
            this.currentRow = new String[this.numberOfColumns];
            for (int i = 0; i < this.numberOfColumns; ++i) {
                this.usedForOrdering[i] = false;
                this.previousRow[i] = null;
                this.currentRow[i] = null;
            }
            this.orderingColumns = orderingColumnsOrdinals.stream().map(o -> this.columnNames[o - 1]).collect(Collectors.toList());
            for (Integer ordinal : orderingColumnsOrdinals) {
                this.usedForOrdering[ordinal.intValue() - 1] = true;
            }
        }

        public void setColumn(int ordinal, Object value) {
            this.currentRow[ordinal - 1] = value == null ? null : "" + value;
        }

        public boolean hasValidOrdering() {
            if (this.firstRow) {
                this.firstRow = false;
                return true;
            }
            boolean equalOrdering = true;
            boolean equalRest = true;
            for (int i = 0; i < this.numberOfColumns; ++i) {
                boolean indf = this.isNotDistinctFrom(this.currentRow[i], this.previousRow[i]);
                if (this.usedForOrdering[i]) {
                    equalOrdering = equalOrdering && indf;
                    continue;
                }
                equalRest = equalRest && indf;
            }
            if (equalOrdering) {
                return equalRest;
            }
            return true;
        }

        private boolean isNotDistinctFrom(String a, String b) {
            return a == null ? b == null : a.equals(b);
        }

        public void next() {
            this.previousRow = this.currentRow;
            this.currentRow = new String[this.numberOfColumns];
        }

        public String renderCurrentRow() {
            return this.renderRow(this.currentRow);
        }

        public String renderPreviousRow() {
            return this.renderRow(this.previousRow);
        }

        private String renderRow(String[] values) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.columnNames[i] + "=" + values[i]);
            }
            return sb.toString();
        }

        public List<String> getOrderingColumns() {
            return this.orderingColumns;
        }
    }
}

