/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.DataSourceCommand;
import highfive.exceptions.CouldNotCopyDataException;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.Identifier;
import highfive.model.Table;
import highfive.model.TableHashingMember;
import highfive.model.TableHashingOrdering;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class HashDupesCommand
extends DataSourceCommand {
    public HashDupesCommand(String datasourceName) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("HashDupes", datasourceName);
    }

    @Override
    public void execute() throws SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, NoSuchAlgorithmException, CouldNotHashException, IOException, InvalidHashFileException, CouldNotCopyDataException, InvalidConfigurationException {
        List<Identifier> tableNames = this.ds.getDialect().listTablesNames();
        if (!this.ds.getTableFilter().allTablesFound()) {
            throw new CouldNotHashException("Could not find the following tables declared in the property '" + this.ds.getName() + ".table.filter': " + this.ds.getTableFilter().listNotAccepted().stream().map(n -> n.toString()).collect(Collectors.joining(", ")));
        }
        int tablesWithDupes = 0;
        int failedTables = 0;
        this.info(" ");
        for (Identifier tn : tableNames) {
            this.ds.getConnection().setAutoCommit(true);
            this.ds.getConnection().setAutoCommit(this.ds.getSelectAutoCommit());
            String tid = this.ds.getDialect().renderSQLTableIdentifier(tn);
            Table t = this.ds.getDialect().getTableMetaData(tn);
            String sql = "select count(*) as dupes, sum(cnt) as occurrences from (select count(*) as cnt from " + tid + " group by " + this.getOrderingColumns(t) + " having count(*) > 1) x";
            Statement st = this.ds.getConnection().createStatement();
            Throwable throwable = null;
            try {
                ResultSet rs = st.executeQuery(sql);
                Throwable throwable2 = null;
                try {
                    if (rs.next()) {
                        long dupes = rs.getLong(1);
                        long occurrences = rs.getLong(2);
                        if (dupes > 0L) {
                            this.info("Table '" + tid + "' has " + dupes + " dupes with a total of " + occurrences + " occurrences.");
                            ++tablesWithDupes;
                            continue;
                        }
                        this.info("Table '" + tid + "' has no dupes -- OK");
                        continue;
                    }
                    this.info("Could not count dupes for table '" + tid + "'.");
                    ++failedTables;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (st == null) continue;
                if (throwable != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                st.close();
            }
        }
        if (tablesWithDupes == 0) {
            if (failedTables == 0) {
                this.info("Validation succeeded -- No dupes found in any table.");
            } else {
                this.info("Validation failed -- No dupes found in " + tableNames.size() + " table(s), but " + failedTables + " table(s) could not be inspected.");
            }
        } else {
            this.info("Validation failed -- Dupes were found in " + tablesWithDupes + " out of " + tableNames.size() + " tables.");
        }
    }

    private String getOrderingColumns(Table t) throws CouldNotHashException {
        String orderingColumns = null;
        TableHashingOrdering tho = this.ds.getHashingOrderings().get(t.getIdentifier().getGenericName());
        if (tho != null) {
            try {
                tho.validate(this.ds, t);
            }
            catch (InvalidConfigurationException e) {
                throw new CouldNotHashException(e.getMessage());
            }
            Collection<TableHashingMember> thms = tho.getMembers().values();
            if (thms.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Column c2 : t.getColumns()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    String cm = this.ds.getDialect().escapeIdentifierAsNeeded(c2.getCanonicalName());
                    sb.append(cm);
                }
                orderingColumns = sb.toString();
            } else {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (TableHashingMember m : thms) {
                    Column col = t.findColumn(m.getGenericColumnName());
                    if (col == null) {
                        throw new CouldNotHashException("Could not find column '" + m.getGenericColumnName() + "' specified in the hashing ordering in the table '" + t.getIdentifier().getCanonicalName() + "'.");
                    }
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    String cm = this.ds.getDialect().escapeIdentifierAsNeeded(m.getGenericColumnName());
                    sb.append(cm);
                }
                orderingColumns = sb.toString();
            }
        } else {
            List<Column> pkColumns = t.getPKColumns();
            if (pkColumns.isEmpty()) {
                throw new CouldNotHashException("The schema is not supported since the table '" + t.getIdentifier().getGenericName() + "' has no primary key and no hashing ordering was declared using the property '" + this.ds.getName() + ".hashing.ordering'.");
            }
            orderingColumns = pkColumns.stream().map(c -> this.ds.getDialect().escapeIdentifierAsNeeded(c.getCanonicalName())).collect(Collectors.joining(", "));
        }
        return orderingColumns;
    }
}

