/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.GenericHashCommand;
import highfive.commands.HashDumpCommand;
import highfive.commands.consumer.HashConsumer;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Identifier;
import highfive.model.Table;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.List;

public class HashLoggingCommand
extends GenericHashCommand {
    private HashDumpCommand.HashDumpConfig hashDumpConfig;

    public HashLoggingCommand(String datasourceName, HashDumpCommand.HashDumpConfig hashDumpConfig) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("Hash Logging", datasourceName);
        this.hashDumpConfig = hashDumpConfig;
    }

    @Override
    public void execute() throws NoSuchAlgorithmException, SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, CouldNotHashException, IOException, InvalidHashFileException, InvalidConfigurationException {
        this.info("");
        List<Identifier> tableNames = this.ds.getDialect().listTablesNames();
        Identifier tn = this.findTable(this.hashDumpConfig.getTableName(), tableNames);
        if (tn == null) {
            throw new CouldNotHashException("Could not find the table '" + this.hashDumpConfig.getTableName() + "'");
        }
        Table t = this.ds.getDialect().getTableMetaData(tn);
        File f = new File(this.ds.getHashDumpFileName());
        try (HashConsumer hc = this.hashDumpConfig.getHashConsumer(f);){
            super.hashOneTable(t, hc);
            HashConsumer.ExecutionStatus status = hc.getStatus();
            if (status.successful()) {
                this.info("Hash logging complete");
            } else {
                this.error("Hash logging comparison failed -- " + status.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new CouldNotHashException(e.getMessage());
        }
    }
}

