/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.GenericHashCommand;
import highfive.commands.consumer.HashFileWriter;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.HashFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;

public class VerifyCommand
extends GenericHashCommand {
    private String baselineFile;

    public VerifyCommand(String datasourceName, String baselineFile) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("Verify", datasourceName);
        this.baselineFile = baselineFile;
    }

    @Override
    public void execute() throws FileNotFoundException, IOException, InvalidHashFileException, NoSuchAlgorithmException, SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, CouldNotHashException, InvalidConfigurationException {
        HashFile hashFile;
        HashFile existing = HashFile.loadFrom(this.baselineFile);
        try {
            HashFileWriter hw = new HashFileWriter(this.ds.getHashFileName());
            Object object = null;
            try {
                super.hashOneSchema(hw);
                hashFile = hw.getHashFile();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (hw != null) {
                    if (object != null) {
                        try {
                            hw.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        hw.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new CouldNotHashException(e.getMessage());
        }
        this.info(" ");
        this.info("Verifying hashes:");
        HashFile.ComparisonResult result = existing.compareTo(hashFile, "baseline hash file", "live database");
        for (String err : result.getErrors()) {
            this.error("  - " + err);
        }
        if (result.getErrors().isEmpty()) {
            this.info("  All data hashes match (" + result.getMatched() + " tables) -- The verification succeeded" + (result.isNonDeterministic() ? ", although with warnings, since the hashing ordering was non-deterministic in the source and/or the target databases" : "") + ".");
        } else {
            this.error("  A total of " + result.getMatched() + " tables matched and there were " + result.getErrors().size() + " difference(s) in the hashes -- The verification failed" + (result.isNonDeterministic() ? ", although with warnings, since the hashing ordering was non-deterministic in the source and/or the target databases" : "") + ".");
        }
    }
}

