/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands.consumer;

import highfive.commands.consumer.DumpFileReader;
import highfive.commands.consumer.HashConsumer;
import highfive.exceptions.InvalidHashFileException;
import highfive.model.Column;
import highfive.model.Hasher;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class HashComparator
implements HashConsumer {
    private static final Logger log = Logger.getLogger(HashComparator.class.getName());
    private String tableName;
    private File baseline;
    private DumpFileReader b;
    private boolean beof;
    private Long lastMatchedRow;
    private HashConsumer.ExecutionStatus status;

    public HashComparator(String tableName, File baseline, File current) throws DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
        log.fine("init");
        this.tableName = tableName;
        this.baseline = baseline;
        this.b = new DumpFileReader(baseline);
        this.beof = false;
        this.lastMatchedRow = null;
        this.status = null;
    }

    @Override
    public void initializeHasher(Hasher h) {
    }

    @Override
    public void consumeValueHeader(long row) {
    }

    @Override
    public void consumeValue(long row, Column c, byte[] bytes, Hasher h) throws CloneNotSupportedException {
    }

    @Override
    public boolean consumeRow(long liveRow, Hasher hasher) throws IOException, CloneNotSupportedException, DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
        if (this.status != null) {
            return false;
        }
        while (!this.beof && (this.b.atStart() || this.b.getRow() < liveRow)) {
            this.nextBaseline();
        }
        if (this.beof) {
            if (this.b.getMetadata().getType() == DumpFileReader.DumpFileType.FULL) {
                this.status = HashConsumer.ExecutionStatus.failure("Found more rows in the live table '" + this.tableName + "' than in the baseline file; no matching baseline hash for live row #" + liveRow);
                return false;
            }
            this.status = HashConsumer.ExecutionStatus.success("The live table '" + this.tableName + "' fully matches the partial baseline dump file" + " (rows " + this.b.getMetadata().getStart() + "-" + this.b.getMetadata().getEnd() + ").");
            return false;
        }
        if (this.b.getRow() > liveRow) {
            return true;
        }
        String liveHash = hasher.getOngoingHash();
        if (!liveHash.equals(this.b.getHash())) {
            this.computeErrorStatus(liveRow, liveHash);
            this.nextBaseline();
            return false;
        }
        this.lastMatchedRow = liveRow;
        this.nextBaseline();
        return true;
    }

    private void computeErrorStatus(long liveRow, String liveHash) {
        switch (this.b.getMetadata().getType()) {
            case FULL: {
                this.status = HashConsumer.ExecutionStatus.failure("Found different hashes in row #" + liveRow + " in table '" + this.tableName + "' -- current hash: " + liveHash + " -- baseline hash: " + this.b.getHash());
                break;
            }
            case RANGED: {
                if (this.lastMatchedRow == null && liveRow > 1L) {
                    this.status = HashConsumer.ExecutionStatus.failure("Found different hashes in row #" + liveRow + " in table '" + this.tableName + "' -- current hash: " + liveHash + " -- baseline hash: " + this.b.getHash() + "\n * Note: Since this is a ranged baseline hash dump file, the different row could be in row #" + liveRow + ", or a row before it.");
                    break;
                }
                this.status = HashConsumer.ExecutionStatus.failure("Found different hashes in row #" + liveRow + " in table '" + this.tableName + "' -- current hash: " + liveHash + " -- baseline hash: " + this.b.getHash());
                break;
            }
            case STEPPED: {
                if (this.lastMatchedRow == null) {
                    if (liveRow > 1L) {
                        this.status = HashConsumer.ExecutionStatus.failure("Found different hashes in row #" + liveRow + " in table '" + this.tableName + "' -- current hash: " + liveHash + " -- baseline hash: " + this.b.getHash() + "\n * Note: Since this is a stepped baseline hash dump file, the different row could be in row #" + liveRow + ", or a row before it.");
                        break;
                    }
                    this.status = HashConsumer.ExecutionStatus.failure("Found different hashes in row #" + liveRow + " in table '" + this.tableName + "' -- current hash: " + liveHash + " -- baseline hash: " + this.b.getHash());
                    break;
                }
                this.status = HashConsumer.ExecutionStatus.failure("Found different hashes in row #" + liveRow + " in table '" + this.tableName + "' -- current hash: " + liveHash + " -- baseline hash: " + this.b.getHash() + "\n * Note: Since this is a stepped baseline hash dump file, the different row must be between rows #" + (this.lastMatchedRow + 1L) + " and #" + liveRow + ".");
            }
        }
    }

    private void nextBaseline() throws DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
        if (!this.b.next()) {
            this.beof = true;
        }
    }

    @Override
    public void consumeTable(String genericName, boolean nonDeterministic, boolean failed, long rowCount) throws InvalidHashFileException {
        if (this.status != null) {
            return;
        }
        this.status = !this.beof ? HashConsumer.ExecutionStatus.failure("Found more rows in the baseline file than in the live table '" + this.tableName + "'; the table does not a row #" + this.b.getRow()) : (this.b.getMetadata().getType() == DumpFileReader.DumpFileType.FULL ? HashConsumer.ExecutionStatus.success("The live table '" + this.tableName + "' fully matches the baseline dump file.") : HashConsumer.ExecutionStatus.success("The live table '" + this.tableName + "' fully matches the partial baseline dump file (rows " + this.b.getMetadata().getStart() + "-" + this.b.getMetadata().getEnd() + ")."));
    }

    @Override
    public void close() throws Exception {
        this.b.close();
    }

    @Override
    public HashConsumer.ExecutionStatus getStatus() {
        return this.status;
    }
}

