/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands.consumer;

import highfive.commands.consumer.DumpFileReader;
import highfive.exceptions.InvalidHashFileException;
import highfive.model.Column;
import highfive.model.Hasher;
import java.io.IOException;

public interface HashConsumer
extends AutoCloseable {
    public void initializeHasher(Hasher var1);

    public void consumeValueHeader(long var1);

    public void consumeValue(long var1, Column var3, byte[] var4, Hasher var5) throws CloneNotSupportedException;

    public boolean consumeRow(long var1, Hasher var3) throws IOException, CloneNotSupportedException, DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException;

    public void consumeTable(String var1, boolean var2, boolean var3, long var4) throws InvalidHashFileException;

    public ExecutionStatus getStatus();

    public static class ExecutionStatus {
        private boolean successful;
        private String message;

        private ExecutionStatus(boolean successful, String message) {
            this.successful = successful;
            this.message = message;
        }

        public static ExecutionStatus success(String message) {
            return new ExecutionStatus(true, message);
        }

        public static ExecutionStatus failure(String message) {
            return new ExecutionStatus(false, message);
        }

        public boolean successful() {
            return this.successful;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ExecutionStatus [successful=" + this.successful + ", message=" + this.message + "]";
        }
    }
}

