/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands.consumer;

import highfive.commands.HashDumpCommand;
import highfive.commands.consumer.DumpFileReader;
import highfive.commands.consumer.FullHashDumpWriter;
import highfive.commands.consumer.HashComparator;
import highfive.commands.consumer.HashConsumer;
import highfive.commands.consumer.HashLogger;
import highfive.commands.consumer.RangeHashDumpWriter;
import highfive.commands.consumer.SteppedRangeHashDumpWriter;
import java.io.File;
import java.io.IOException;

public interface HashDumpWriterFactory {
    public HashConsumer getInstance(HashDumpCommand.HashDumpConfig var1, File var2) throws IOException, DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException;

    public static class SteppedHashDumpWriterFactory
    implements HashDumpWriterFactory {
        @Override
        public HashConsumer getInstance(HashDumpCommand.HashDumpConfig config, File f) throws IOException {
            return new SteppedRangeHashDumpWriter(config.getTableName(), f, config.getStart(), config.getEnd(), config.getStep());
        }
    }

    public static class RangeHashDumpWriterFactory
    implements HashDumpWriterFactory {
        @Override
        public HashConsumer getInstance(HashDumpCommand.HashDumpConfig config, File f) throws IOException {
            return new RangeHashDumpWriter(config.getTableName(), f, config.getStart(), config.getEnd());
        }
    }

    public static class FullHashDumpWriterFactory
    implements HashDumpWriterFactory {
        @Override
        public HashConsumer getInstance(HashDumpCommand.HashDumpConfig config, File f) throws IOException {
            return new FullHashDumpWriter(config.getTableName(), f);
        }
    }

    public static class HashDumpLoggerFactory
    implements HashDumpWriterFactory {
        private long start;
        private long end;

        public HashDumpLoggerFactory(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public HashConsumer getInstance(HashDumpCommand.HashDumpConfig config, File current) throws IOException, DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
            return new HashLogger(config.getTableName(), this.start, this.end);
        }
    }

    public static class HashDumpComparatorFactory
    implements HashDumpWriterFactory {
        private File baseline;

        public HashDumpComparatorFactory(File baseline) {
            this.baseline = baseline;
        }

        @Override
        public HashConsumer getInstance(HashDumpCommand.HashDumpConfig config, File current) throws IOException, DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
            return new HashComparator(config.getTableName(), this.baseline, current);
        }
    }
}

