/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands.consumer;

import highfive.commands.consumer.DumpFileReader;
import highfive.commands.consumer.HashConsumer;
import highfive.exceptions.InvalidHashFileException;
import highfive.model.Column;
import highfive.model.Hasher;
import highfive.utils.Utl;
import java.io.IOException;
import java.util.logging.Logger;

public class HashLogger
implements HashConsumer {
    private static final Logger log = Logger.getLogger(HashLogger.class.getName());
    private String tableName;
    private long start;
    private long end;
    private HashConsumer.ExecutionStatus status;

    public HashLogger(String tableName, long start, long end) throws DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
        log.fine("init");
        this.tableName = tableName;
        this.start = start;
        this.end = end;
        this.status = null;
    }

    @Override
    public void initializeHasher(Hasher h) {
    }

    @Override
    public void consumeValueHeader(long row) {
        if (row >= this.start && row <= this.end) {
            log.info("    * Row #" + row + ":");
        }
    }

    @Override
    public void consumeValue(long row, Column c, byte[] bytes, Hasher h) throws CloneNotSupportedException {
        if (row >= this.start && row <= this.end) {
            byte[] d = h.getInProgressDigest();
            log.info("      " + c.getName() + ": '" + c.getSerializer().getValue() + "' - encoded: " + Utl.toHex(bytes) + " -- hash: " + Utl.toHex(d));
        }
    }

    @Override
    public boolean consumeRow(long row, Hasher hasher) throws IOException, CloneNotSupportedException, DumpFileReader.InvalidDumpFileException, DumpFileReader.DumpFileIOException {
        return row < this.end;
    }

    @Override
    public void consumeTable(String genericName, boolean nonDeterministic, boolean failed, long rowCount) throws InvalidHashFileException {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public HashConsumer.ExecutionStatus getStatus() {
        return HashConsumer.ExecutionStatus.success("");
    }
}

