/*
 * Decompiled with CFR 0.152.
 */
package highfive.dialects;

import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.DataSource;
import highfive.model.Dialect;
import highfive.model.Identifier;
import highfive.model.PKColumn;
import highfive.model.Serializer;
import highfive.model.Table;
import highfive.serializers.BigDecimalSerializer;
import highfive.serializers.BooleanSerializer;
import highfive.serializers.ByteArraySerializer;
import highfive.serializers.DoubleSerializer;
import highfive.serializers.IntegerSerializer;
import highfive.serializers.LocalDateSerializer;
import highfive.serializers.LocalDateTimeSerializer;
import highfive.serializers.LocalTimeSerializer;
import highfive.serializers.LongSerializer;
import highfive.serializers.OffsetDateTimeSerializer;
import highfive.serializers.StringSerializer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PostgreSQLDialect
extends Dialect {
    private static final Logger log = Logger.getLogger(PostgreSQLDialect.class.getName());
    private static Set<String> MUST_ESCAPE = new HashSet<String>();

    public PostgreSQLDialect(DataSource ds, Connection conn) {
        super(ds, conn);
    }

    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public List<Identifier> listTablesNames() throws SQLException, InvalidSchemaException {
        ArrayList<Identifier> tables = new ArrayList<Identifier>();
        String sql = "select table_name from information_schema.tables where table_schema = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, this.ds.getSchema());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String table = rs.getString(1);
                    if (rs.wasNull()) {
                        throw new InvalidSchemaException("The schema includes a table with no name.");
                    }
                    if (!this.ds.getTableFilter().accepts(table)) continue;
                    tables.add(new Identifier(table, this.ds.getRemoveTablePrefix(), this));
                }
            }
        }
        return tables;
    }

    @Override
    public Table getTableMetaData(Identifier tn) throws SQLException, UnsupportedDatabaseTypeException {
        List<PKColumn> pkColumns = this.getPrimaryKeyColumns(this.conn, this.ds.getSchema(), tn);
        Map<String, Integer> pkByName = pkColumns.stream().collect(Collectors.toMap(x -> x.getCanonicalName(), x -> x.getPosition()));
        ArrayList<Column> columns = new ArrayList<Column>();
        String sql = "select column_name, data_type, character_maximum_length, numeric_precision, numeric_scale\nfrom information_schema.columns where table_schema = ? and table_name = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, this.ds.getSchema());
            ps.setString(2, tn.getCanonicalName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Integer len;
                    int col = 1;
                    String name = this.readString(rs, col++);
                    if (!this.ds.getColumnFilter().accepts(name)) continue;
                    String type = this.readString(rs, col++);
                    boolean unsigned = false;
                    BigInteger length = (len = this.readInt(rs, col++)) == null ? null : BigInteger.valueOf(len.longValue());
                    Integer precision = this.readInt(rs, col++);
                    Integer scale = this.readInt(rs, col++);
                    Integer pkPosition = pkByName.get(name);
                    String renderedType = this.renderType(name, type, length, precision, scale);
                    Serializer<?> serializer = super.getSerializer(renderedType, tn, name, type, unsigned, length, precision, scale);
                    Column c = new Column(name, type, length, precision, scale, renderedType, pkPosition, serializer);
                    columns.add(c);
                }
            }
        }
        return new Table(tn, columns);
    }

    private String renderType(String name, String type, BigInteger maxLength, Integer precision, Integer scale) {
        if ("character".equals(type) || "character varying".equals(type)) {
            return type + "(" + maxLength + ")";
        }
        if ("text".equals(type)) {
            return type;
        }
        if ("smallint".equals(type) || "integer".equals(type) || "bigint".equals(type)) {
            return type;
        }
        if ("numeric".equals(type)) {
            return type + "(" + precision + ", " + scale + ")";
        }
        if ("real".equals(type) || "double precision".equals(type)) {
            return type;
        }
        if ("date".equals(type) || "timestamp without time zone".equals(type) || "timestamp with time zone".equals(type) || "time without time zone".equals(type) || "time with time zone".equals(type) || "interval".equals(type)) {
            return type;
        }
        if ("bytea".equals(type)) {
            return type;
        }
        if ("boolean".equals(type)) {
            return type;
        }
        return type;
    }

    @Override
    protected Serializer<?> getDefaultSerializer(Identifier table, String name, String type, boolean unsigned, BigInteger maxLength, Integer precision, Integer scale) throws UnsupportedDatabaseTypeException {
        if ("character".equals(type) || "character varying".equals(type) || "text".equals(type)) {
            return new StringSerializer();
        }
        if ("smallint".equals(type) || "integer".equals(type)) {
            return new IntegerSerializer();
        }
        if ("bigint".equals(type)) {
            return new LongSerializer();
        }
        if ("numeric".equals(type)) {
            return new BigDecimalSerializer();
        }
        if ("real".equals(type) || "double precision".equals(type)) {
            return new DoubleSerializer();
        }
        if ("date".equals(type)) {
            return new LocalDateSerializer();
        }
        if ("timestamp without time zone".equals(type)) {
            return new LocalDateTimeSerializer();
        }
        if ("timestamp with time zone".equals(type)) {
            return new OffsetDateTimeSerializer();
        }
        if ("time without time zone".equals(type)) {
            return new LocalTimeSerializer();
        }
        if ("time with time zone".equals(type) || "interval".equals(type)) {
            throw new UnsupportedDatabaseTypeException("Unsupported column type for column " + name + " in table " + table + ": " + type);
        }
        if ("bytea".equals(type)) {
            return new ByteArraySerializer();
        }
        if ("boolean".equals(type)) {
            return new BooleanSerializer();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private List<PKColumn> getPrimaryKeyColumns(Connection conn, String schema, Identifier table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readString(ResultSet rs, int ordinal) throws SQLException {
        String v = rs.getString(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private Integer readInt(ResultSet rs, int ordinal) throws SQLException {
        Integer v = rs.getInt(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private <T> T readObject(ResultSet rs, int ordinal, Class<T> cls) throws SQLException {
        T v = rs.getObject(ordinal, cls);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    @Override
    public String escapeIdentifierAsNeeded(String canonicalName) {
        if (canonicalName.matches("^[a-z0-9_]+$") && !MUST_ESCAPE.contains(canonicalName)) {
            return canonicalName;
        }
        return "\"" + canonicalName.replace("\"", "\"\"") + "\"";
    }

    @Override
    public String addCollation(String columnCanonicalName, String collation) {
        return columnCanonicalName + " collate \"" + collation + "\"";
    }

    @Override
    public String renderSQLTableIdentifier(Identifier table) {
        return (this.ds.getSchema() == null ? "" : this.escapeIdentifierAsNeeded(this.ds.getSchema()) + ".") + table.renderSQL();
    }

    @Override
    public String renderHeadLimit(Long limit) {
        return "";
    }

    @Override
    public String renderTailLimit(Long limit) {
        return limit == null ? "" : " limit " + limit;
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return false;
    }

    @Override
    public String renderNullsOrdering(boolean nullsFirst) {
        return nullsFirst ? " nulls first" : " nulls last";
    }

    static {
        MUST_ESCAPE.add("CASE");
        MUST_ESCAPE.add("case");
    }
}

