/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.model.OptionalProperty;
import highfive.utils.Name;
import java.util.Set;
import java.util.stream.Collectors;

public class ColumnFilter
implements OptionalProperty {
    private Set<String> allowedColumns;

    public ColumnFilter(Set<String> allowedColumns) {
        this.allowedColumns = allowedColumns;
        this.allowedColumns = this.allowedColumns == null || this.allowedColumns.isEmpty() ? null : this.allowedColumns.stream().map(n -> Name.lower(n)).collect(Collectors.toSet());
    }

    public boolean accepts(String canonicalName) {
        if (this.allowedColumns == null) {
            return true;
        }
        if (canonicalName == null) {
            return false;
        }
        return this.allowedColumns.contains(canonicalName.toLowerCase());
    }

    public String render() {
        return this.allowedColumns == null ? "" : this.allowedColumns.stream().collect(Collectors.joining(","));
    }

    @Override
    public boolean declared() {
        return this.allowedColumns != null;
    }
}

