/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.exceptions.UnsupportedSQLFeatureException;
import highfive.model.DataSource;
import highfive.model.Identifier;
import highfive.model.Serializer;
import highfive.model.Table;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class Dialect {
    protected DataSource ds;
    protected Connection conn;

    public Dialect(DataSource ds, Connection conn) {
        this.ds = ds;
        this.conn = conn;
    }

    protected Serializer<?> getSerializer(String renderedType, Identifier table, String name, String type, boolean unsigned, BigInteger maxLength, Integer precision, Integer scale) throws UnsupportedDatabaseTypeException {
        Serializer<?> ruleSerializer = this.ds.getTypeSolver().resolve(renderedType);
        if (ruleSerializer != null) {
            return ruleSerializer;
        }
        return this.getDefaultSerializer(table, name, type, unsigned, maxLength, precision, scale);
    }

    public abstract String getName();

    public abstract List<Identifier> listTablesNames() throws SQLException, InvalidSchemaException;

    public abstract Table getTableMetaData(Identifier var1) throws SQLException, UnsupportedDatabaseTypeException;

    protected abstract Serializer<?> getDefaultSerializer(Identifier var1, String var2, String var3, boolean var4, BigInteger var5, Integer var6, Integer var7) throws UnsupportedDatabaseTypeException;

    public abstract String escapeIdentifierAsNeeded(String var1);

    public abstract String addCollation(String var1, String var2);

    public abstract String renderSQLTableIdentifier(Identifier var1);

    public abstract String renderHeadLimit(Long var1);

    public abstract String renderTailLimit(Long var1);

    public abstract Boolean getDefaultAutoCommit();

    public abstract String renderNullsOrdering(boolean var1) throws UnsupportedSQLFeatureException;
}

