/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.dialects.DB2Dialect;
import highfive.dialects.MariaDBDialect;
import highfive.dialects.MySQLDialect;
import highfive.dialects.OracleDialect;
import highfive.dialects.PostgreSQLDialect;
import highfive.dialects.SQLServerDialect;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.DataSource;
import highfive.model.Dialect;
import highfive.model.DialectNormalizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DialectFactory {
    public static Dialect getDialect(DataSource ds) throws SQLException, UnsupportedDatabaseTypeException {
        Connection conn = ds.getConnection();
        DatabaseMetaData dm = conn.getMetaData();
        String name = dm.getDatabaseProductName();
        String version = dm.getDatabaseProductVersion();
        String uName = name.toUpperCase();
        if (uName.startsWith("ORACLE")) {
            return new DialectNormalizer(new OracleDialect(ds, conn));
        }
        if (uName.startsWith("DB2/")) {
            return new DialectNormalizer(new DB2Dialect(ds, conn));
        }
        if (uName.startsWith("POSTGRESQL")) {
            return new DialectNormalizer(new PostgreSQLDialect(ds, conn));
        }
        if (name.startsWith("Microsoft SQL Server")) {
            return new DialectNormalizer(new SQLServerDialect(ds, conn));
        }
        if (name.equals("MySQL")) {
            if (version.indexOf("MariaDB") != -1) {
                return new DialectNormalizer(new MariaDBDialect(ds, conn));
            }
            return new DialectNormalizer(new MySQLDialect(ds, conn));
        }
        throw new UnsupportedDatabaseTypeException("Could not resolve the database dialect. The product name reported by the JDBC driver '" + name + "' is not supported by HighFive.");
    }
}

