/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.exceptions.InvalidHashFileException;
import highfive.model.TableHash;
import highfive.utils.Utl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HashFile {
    private static final Logger log = Logger.getLogger(HashFile.class.getName());
    private Map<String, TableHash> map = new LinkedHashMap<String, TableHash>();
    private static final Pattern LINE_PATTERN = Pattern.compile("^([0-9a-f]{64})(\\*?)(\\!?) ([0-9]+) (.+)$");
    private static final DecimalFormat DF = new DecimalFormat("#,##0");

    public void add(String hash, boolean nonDeterministic, boolean failed, long rowCount, String table) throws InvalidHashFileException {
        if (this.map.containsKey(table)) {
            throw new InvalidHashFileException("Duplicate table '" + table + "'.");
        }
        this.map.put(table, new TableHash(hash, nonDeterministic, failed, rowCount));
    }

    public void saveTo(String file) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new FileWriter(new File(file)));){
            for (String table : this.map.keySet()) {
                TableHash h = this.map.get(table);
                w.write(h.getHash() + (h.isNonDeterministic() ? "*" : "") + (h.isFailed() ? "!" : "") + " " + h.getRowCount() + " " + table + "\n");
            }
        }
    }

    public static HashFile loadFrom(String file) throws FileNotFoundException, IOException, InvalidHashFileException {
        HashFile hf = new HashFile();
        try (BufferedReader r = new BufferedReader(new FileReader(new File(file)));){
            String line;
            int lineNumber = 1;
            while ((line = r.readLine()) != null) {
                Matcher m = LINE_PATTERN.matcher(line);
                if (!m.matches()) {
                    throw new InvalidHashFileException("Line #" + lineNumber + " has an invalid hash format. Must be a 64-char hexa value, " + "optionally followed by a star, " + "optionally followed by an exclamation point, " + "then a space and a table name (in lower case).");
                }
                String hash = m.group(1);
                String star = m.group(2);
                boolean nonDeterministic = star.equals("*");
                String exclamation = m.group(3);
                boolean failed = exclamation.equals("!");
                String srows = m.group(4);
                long rowCount = Long.parseLong(srows);
                String table = m.group(5);
                hf.add(hash, nonDeterministic, failed, rowCount, table);
                ++lineNumber;
            }
        }
        return hf;
    }

    public ComparisonResult compareTo(HashFile other, String thisName, String otherName) {
        ComparisonResult r = new ComparisonResult();
        for (String table : this.map.keySet()) {
            String where;
            TableHash h = this.map.get(table);
            if (!other.map.containsKey(table)) {
                r.addError("Table '" + table + "' found in the " + thisName + ", but not in the " + otherName + ".");
                continue;
            }
            TableHash o = other.map.get(table);
            if (h.isFailed() || o.isFailed()) {
                where = h.isFailed() ? (o.isFailed() ? "the live and baseline tables" : "the baseline table") : "the live table";
                r.addError("Failed to compare hashes for the table '" + table + "' in the databases; failed to read and inspect " + where + ".");
                continue;
            }
            if (h.isNonDeterministic() || o.isNonDeterministic()) {
                where = h.isNonDeterministic() ? (o.isNonDeterministic() ? "the live and baseline tables" : "the baseline table") : "the live table";
                r.addError("Failed to compare hashes for the table '" + table + "' in the databases; the hashing ordering is non-deterministic in " + where + ".");
                continue;
            }
            if (h.getRowCount() != o.getRowCount()) {
                r.addError("Failed to compare hashes for the table '" + table + "'; the current table has " + DF.format(h.getRowCount()) + " row(s) while the baseline table has " + DF.format(o.getRowCount()) + " row(s).");
                continue;
            }
            if (Utl.distinct(h.getHash(), o.getHash())) {
                r.addError("Different hash values found for table '" + table + "' in the databases.");
                continue;
            }
            r.addMatched();
        }
        for (String table : other.map.keySet()) {
            if (this.map.containsKey(table)) continue;
            r.addError("Table '" + table + "' found in the " + otherName + ", but not in the " + thisName + ".");
        }
        if (this.isNonDeterministic() || other.isNonDeterministic()) {
            r.setNonDeterministic();
        }
        return r;
    }

    public boolean isNonDeterministic() {
        for (TableHash h : this.map.values()) {
            if (!h.isNonDeterministic()) continue;
            return true;
        }
        return false;
    }

    public static class ComparisonResult {
        private int matched = 0;
        private boolean nonDeterministic = false;
        private List<String> errors = new ArrayList<String>();

        public void addMatched() {
            ++this.matched;
        }

        public void addError(String error) {
            this.errors.add(error);
        }

        public int getMatched() {
            return this.matched;
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public void setNonDeterministic() {
            this.nonDeterministic = true;
        }

        public boolean isNonDeterministic() {
            return this.nonDeterministic;
        }
    }
}

