/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.utils.Utl;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hasher {
    private static final byte[] NULL = new byte[]{123};
    private MessageDigest digest = MessageDigest.getInstance("SHA-256");
    private boolean active = true;

    public void apply(byte[] v) {
        if (!this.active) {
            throw new RuntimeException("Hasher is already closed.");
        }
        this.digest.update(v == null ? NULL : v);
    }

    public byte[] getInProgressDigest() throws CloneNotSupportedException {
        MessageDigest c = (MessageDigest)this.digest.clone();
        return c.digest();
    }

    public String getOngoingHash() throws CloneNotSupportedException {
        return Utl.toHex(this.getInProgressDigest());
    }

    public byte[] close() {
        if (!this.active) {
            throw new RuntimeException("Hasher is already closed.");
        }
        this.active = false;
        return this.digest.digest();
    }
}

