/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.serializers.BigDecimalSerializer;
import highfive.serializers.BigIntegerSerializer;
import highfive.serializers.BooleanSerializer;
import highfive.serializers.ByteArraySerializer;
import highfive.serializers.DoubleSerializer;
import highfive.serializers.IntegerSerializer;
import highfive.serializers.LocalDateSerializer;
import highfive.serializers.LocalDateTimeSerializer;
import highfive.serializers.LocalTimeSerializer;
import highfive.serializers.LongSerializer;
import highfive.serializers.OffsetDateTimeSerializer;
import highfive.serializers.StringSerializer;
import highfive.serializers.ZonedDateTimeSerializer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class Serializer<T> {
    private String name;
    private boolean canUseACollation;
    public static Map<String, Serializer<?>> ALL = new HashMap();

    protected Serializer(boolean canUseACollation) {
        String sn = this.getClass().getSimpleName();
        this.name = sn.substring(0, sn.length() - "Serializer".length()).toLowerCase();
        this.canUseACollation = canUseACollation;
    }

    private static void add(Serializer<?> ... serializers) {
        for (Serializer<?> s : serializers) {
            ALL.put(s.name, s);
        }
    }

    public static Serializer<?> find(String name) {
        if (name == null) {
            return null;
        }
        return ALL.get(name.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public boolean canUseACollation() {
        return this.canUseACollation;
    }

    public abstract T getValue();

    public abstract byte[] read(ResultSet var1, int var2) throws SQLException;

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    static {
        Serializer.add(new BigDecimalSerializer(), new BigIntegerSerializer(), new BooleanSerializer(), new ByteArraySerializer(), new DoubleSerializer(), new IntegerSerializer(), new LocalDateSerializer(), new LocalDateTimeSerializer(), new LocalTimeSerializer(), new LongSerializer(), new OffsetDateTimeSerializer(), new StringSerializer(), new ZonedDateTimeSerializer());
    }
}

