/*
 * Decompiled with CFR 0.152.
 */
package highfive.serializers;

import highfive.model.Serializer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanSerializer
extends Serializer<Boolean> {
    private static final byte[] FALSE = new byte[]{-89};
    private static final byte[] TRUE = new byte[]{82};
    private Boolean value;

    public BooleanSerializer() {
        super(false);
    }

    @Override
    public byte[] read(ResultSet rs, int ordinal) throws SQLException {
        this.value = rs.getBoolean(ordinal);
        if (rs.wasNull()) {
            this.value = null;
            return null;
        }
        return this.value != false ? TRUE : FALSE;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement ps, int ordinal) throws SQLException {
        ps.setBoolean(ordinal, this.value);
    }
}

