/*
 * Decompiled with CFR 0.152.
 */
package highfive.serializers;

import highfive.model.Serializer;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class DB2LocalDateTimeSerializer
extends Serializer<LocalDateTime> {
    private static ByteBuffer LB = ByteBuffer.allocate(8);
    private LocalDateTime value;

    public DB2LocalDateTimeSerializer() {
        super(false);
    }

    @Override
    public byte[] read(ResultSet rs, int ordinal) throws SQLException {
        rs.getObject(ordinal);
        if (rs.wasNull()) {
            this.value = null;
            return null;
        }
        this.value = rs.getObject(ordinal, LocalDateTime.class);
        LB.putLong(0, this.value.toEpochSecond(ZoneOffset.UTC));
        return LB.array();
    }

    @Override
    public LocalDateTime getValue() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement ps, int ordinal) throws SQLException {
        ps.setObject(ordinal, this.value);
    }
}

