/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.activemq.impl;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.activemq.impl.ActivemqProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqConsumeHandler
implements MessageListener {
    static Logger log = LoggerFactory.getLogger(ActivemqConsumeHandler.class);
    private CloudEventObserverManger observerManger;
    private ActivemqProducer producer;

    public ActivemqConsumeHandler(CloudEventObserverManger observerManger, ActivemqProducer producer) {
        this.observerManger = observerManger;
        this.producer = producer;
    }

    public void onMessage(Message message) {
        TextMessage textmsg = (TextMessage)message;
        try {
            Event event = (Event)ONode.deserialize((String)textmsg.getText(), Event.class);
            boolean isOk = this.onReceive(event);
            if (!isOk) {
                event.times(event.times() + 1);
                try {
                    isOk = this.producer.publish(event, this.getTopic(event));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            EventBus.push((Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private boolean onReceive(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        String topicNew = this.getTopic(event);
        handler = this.observerManger.getByTopic(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }

    private String getTopic(Event event) {
        String topicNew = event.topic();
        return topicNew;
    }
}

