/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.activemq.impl;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.noear.snack.ONode;
import org.noear.solon.cloud.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqProducer {
    static Logger log = LoggerFactory.getLogger(ActivemqProducer.class);
    private ActiveMQConnectionFactory factory;
    private Connection connection;

    public ActivemqProducer(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    private void init() throws JMSException {
        this.connection = this.factory.createConnection();
        this.connection.start();
    }

    private void close() throws JMSException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean publish(Event event, String topic) throws JMSException {
        this.init();
        Session session = this.connection.createSession(false, 1);
        Topic destination = session.createTopic(topic);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage message = session.createTextMessage(ONode.stringify((Object)event));
        try {
            producer.send((Destination)destination, (Message)message);
            boolean bl = true;
            return bl;
        }
        catch (JMSException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
    }
}

