/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.activemq.impl;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.activemq.ActivemqProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqConsumeHandler
implements MessageListener {
    static Logger log = LoggerFactory.getLogger(ActivemqConsumeHandler.class);
    private CloudEventObserverManger observerManger;
    private Session session;

    public ActivemqConsumeHandler(CloudEventObserverManger observerManger, Session session) {
        this.observerManger = observerManger;
        this.session = session;
    }

    public void onMessage(Message message) {
        ActiveMQTextMessage textmsg = (ActiveMQTextMessage)message;
        try {
            Event event = (Event)ONode.deserialize((String)textmsg.getText(), Event.class);
            event.times(textmsg.getRedeliveryCounter());
            boolean isOk = this.onReceive(event);
            if (isOk) {
                textmsg.acknowledge();
            } else {
                this.session.recover();
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            EventBus.publishTry((Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private boolean onReceive(Event event) throws Throwable {
        try {
            return this.onReceiveDo(event);
        }
        catch (Throwable e) {
            EventBus.publishTry((Object)e);
            return false;
        }
    }

    private boolean onReceiveDo(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        String topicNew = this.getTopicNew(event);
        handler = this.observerManger.getByTopic(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }

    private String getTopicNew(Event event) {
        return ActivemqProps.getTopicNew(event);
    }
}

