/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.activemq.service;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.activemq.ActivemqProps;
import org.noear.solon.cloud.extend.activemq.impl.ActivemqConsumer;
import org.noear.solon.cloud.extend.activemq.impl.ActivemqProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceActivemqImp
implements CloudEventServicePlus {
    static Logger log = LoggerFactory.getLogger(CloudEventServiceActivemqImp.class);
    private CloudProps cloudProps;
    private ActivemqProducer producer;
    private ActivemqConsumer consumer;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceActivemqImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        ActiveMQConnectionFactory factory = null;
        String brokerUrl = cloudProps.getEventServer();
        if (brokerUrl.indexOf("://") < 0) {
            brokerUrl = "tcp://" + brokerUrl;
        }
        String username = cloudProps.getUsername();
        String password = cloudProps.getPassword();
        factory = Utils.isEmpty((String)cloudProps.getUsername()) ? new ActiveMQConnectionFactory(brokerUrl) : new ActiveMQConnectionFactory(username, password, brokerUrl);
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setInitialRedeliveryDelay(5000L);
        redeliveryPolicy.setBackOffMultiplier(2.0);
        redeliveryPolicy.setUseExponentialBackOff(true);
        redeliveryPolicy.setMaximumRedeliveries(-1);
        redeliveryPolicy.setMaximumRedeliveryDelay(0x6DDD00L);
        factory.setRedeliveryPolicy(redeliveryPolicy);
        this.producer = new ActivemqProducer(factory);
        this.consumer = new ActivemqConsumer(factory, this.producer);
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        String topicNew = ActivemqProps.getTopicNew(event);
        try {
            boolean re = this.producer.publish(event, topicNew);
            return re;
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public void subscribe() {
        try {
            if (this.observerManger.topicSize() > 0) {
                this.consumer.init(this.observerManger);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

