/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.activemq.impl;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.noear.solon.cloud.extend.activemq.impl.ActivemqConsumeHandler;
import org.noear.solon.cloud.extend.activemq.impl.ActivemqProducer;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqConsumer {
    static Logger log = LoggerFactory.getLogger(ActivemqConsumer.class);
    private ActiveMQConnectionFactory factory;
    private ActivemqProducer producer;
    private Connection connection;
    private ActivemqConsumeHandler handler;

    public ActivemqConsumer(ActiveMQConnectionFactory factory, ActivemqProducer producer) {
        this.factory = factory;
        this.producer = producer;
    }

    public void init(CloudEventObserverManger observerManger) throws JMSException {
        if (this.connection != null) {
            return;
        }
        this.connection = this.factory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        this.handler = new ActivemqConsumeHandler(observerManger, session);
        for (String topic : observerManger.topicAll()) {
            Topic destination = session.createTopic(topic);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            consumer.setMessageListener((MessageListener)this.handler);
        }
    }

    public void close() throws JMSException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

