/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.activemq.impl;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.noear.snack.ONode;
import org.noear.solon.cloud.extend.activemq.impl.ActivemqTransactionListener;
import org.noear.solon.cloud.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqProducer {
    static Logger log = LoggerFactory.getLogger(ActivemqProducer.class);
    private ActiveMQConnectionFactory factory;
    private Connection connection;

    public ActivemqProducer(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws JMSException {
        if (this.connection == null) {
            ActiveMQConnectionFactory activeMQConnectionFactory = this.factory;
            synchronized (activeMQConnectionFactory) {
                if (this.connection == null) {
                    this.connection = this.factory.createConnection();
                    this.connection.start();
                }
            }
        }
    }

    private void close() throws JMSException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public boolean publish(Event event, String topic) throws Exception {
        long delay = 0L;
        if (event.scheduled() != null) {
            delay = event.scheduled().getTime() - System.currentTimeMillis();
        }
        if (event.created() == 0L) {
            event.created(System.currentTimeMillis());
        }
        if (delay > 0L) {
            return this.publish(event, topic, delay);
        }
        return this.publish(event, topic, 0L);
    }

    public Session beginTransaction() throws JMSException {
        this.init();
        return this.connection.createSession(true, 2);
    }

    public boolean publish(Event event, String topic, long delay) throws JMSException {
        this.init();
        Session session = null;
        session = event.tran() == null ? this.connection.createSession(false, 2) : ((ActivemqTransactionListener)event.tran().getListener(ActivemqTransactionListener.class)).getTransaction();
        Topic destination = session.createTopic(topic);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage textMessage = session.createTextMessage(ONode.stringify((Object)event));
        if (delay > 0L) {
            textMessage.setLongProperty("AMQ_SCHEDULED_DELAY", delay);
        }
        try {
            producer.send((Destination)destination, (Message)textMessage);
            return true;
        }
        catch (JMSException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

