/*
 * Decompiled with CFR 0.152.
 */
package org.noear.bcf.integration.solon;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.bcf.BcfClient;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.weed.DbContext;
import org.noear.weed.cache.ICacheServiceEx;
import org.noear.weed.cache.memcached.MemCache;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        String p_root = app.cfg().get("bcf.root");
        if (Utils.isEmpty((String)p_root)) {
            p_root = Solon.cfg().appName();
        }
        Props p_cache = app.cfg().getProp("bcf.cache");
        Props p_db = app.cfg().getProp("bcf.db");
        if (p_cache.size() > 1 && p_db.size() > 1 && p_root != null) {
            MemCache cache = new MemCache((Properties)p_cache);
            DbContext db = this.getDbDo((Properties)p_db);
            BcfClient.tryInit((String)p_root, (ICacheServiceEx)cache, (DbContext)db);
        }
        app.get("/_session/domain.js", ctx -> {
            String domain = app.cfg().get("server.session.state.domain");
            if (!XPluginImp.isEmpty(domain) && ctx.uri().getHost().indexOf(domain) >= 0) {
                ctx.contentType("text/javascript");
                ctx.output("try { document.domain = '" + domain + "'; }catch (err) { }");
            }
        });
    }

    private DbContext getDbDo(Properties prop) {
        String url = prop.getProperty("url");
        if (XPluginImp.isEmpty(url)) {
            return null;
        }
        DbContext db = new DbContext();
        HikariDataSource source = new HikariDataSource();
        String schema = prop.getProperty("schema");
        String username = prop.getProperty("username");
        String password = prop.getProperty("password");
        String driverClassName = prop.getProperty("driverClassName");
        if (!XPluginImp.isEmpty(url)) {
            source.setJdbcUrl(url);
        }
        if (!XPluginImp.isEmpty(username)) {
            source.setUsername(username);
        }
        if (!XPluginImp.isEmpty(password)) {
            source.setPassword(password);
        }
        if (!XPluginImp.isEmpty(schema)) {
            source.setSchema(schema);
        }
        if (!XPluginImp.isEmpty(driverClassName)) {
            source.setDriverClassName(driverClassName);
        }
        db.dataSourceSet((DataSource)source);
        db.schemaSet(schema);
        return db;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

