/*
 * Decompiled with CFR 0.152.
 */
package org.noear.bcf;

import org.noear.bcf.BcfClient;
import org.noear.bcf.models.BcfUserModel;
import org.noear.solon.core.handle.Context;

public abstract class BcfSessionBase {
    private static BcfSessionBase _global;

    public static BcfSessionBase global() {
        return _global;
    }

    public BcfSessionBase() {
        if (_global == null) {
            _global = this;
        }
    }

    public Context context() {
        return Context.current();
    }

    protected <T> T doGet(String key, T def) {
        Object tmp = this.context().session(key);
        if (tmp == null) {
            return def;
        }
        return (T)tmp;
    }

    protected void doSet(String key, Object val) {
        this.context().sessionSet(key, val);
    }

    protected boolean doHas(String key) {
        return this.context().session(key) != null;
    }

    public abstract String service();

    public void loadModel(String userID, String password) throws Exception {
        this.loadModel(BcfClient.login((String)userID, (String)password));
    }

    public abstract void loadModel(BcfUserModel var1) throws Exception;

    private int doGetPuid() {
        return this.doGet("puid", 0);
    }

    public final int getPUID() {
        int temp = this.doGetPuid();
        if (temp > 0 && this.hasReload()) {
            try {
                BcfUserModel user = BcfClient.login((int)temp);
                this.loadModel(user);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return temp;
    }

    public final void setPUID(int puid) {
        this.doSet("puid", puid);
        this.set("puid", puid);
    }

    public final String getUserId() {
        return this.doGet("user_id", null);
    }

    public final void setUserId(String user_id) {
        this.doSet("user_id", user_id);
    }

    public final String getUserName() {
        return this.doGet("user_name", null);
    }

    public final void setUserName(String user_name) {
        this.doSet("user_name", user_name);
    }

    private boolean hasReload() {
        return this.doGetPuid() != this.servicePUID();
    }

    public boolean has(String key) {
        return this.doHas(this.service() + "_" + key);
    }

    private int servicePUID() {
        return this.get("puid", 0);
    }

    public void set(String key, Object val) {
        this.doSet(this.service() + "_" + key, val);
    }

    public <T> T get(String key, T def) {
        return this.doGet(this.service() + "_" + key, def);
    }
}

