/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.solon;

import cn.zhxu.bs.BeanReflector;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.MetaResolver;
import cn.zhxu.bs.PageExtractor;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.ParamResolver;
import cn.zhxu.bs.ResultFilter;
import cn.zhxu.bs.SnippetResolver;
import cn.zhxu.bs.SqlExecutor;
import cn.zhxu.bs.SqlInterceptor;
import cn.zhxu.bs.SqlResolver;
import cn.zhxu.bs.convertor.B2MFieldConvertor;
import cn.zhxu.bs.convertor.BoolFieldConvertor;
import cn.zhxu.bs.convertor.BoolNumFieldConvertor;
import cn.zhxu.bs.convertor.BoolParamConvertor;
import cn.zhxu.bs.convertor.DateFieldConvertor;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.convertor.DateParamConvertor;
import cn.zhxu.bs.convertor.DateTimeParamConvertor;
import cn.zhxu.bs.convertor.EnumFieldConvertor;
import cn.zhxu.bs.convertor.JsonFieldConvertor;
import cn.zhxu.bs.convertor.ListFieldConvertor;
import cn.zhxu.bs.convertor.NumberFieldConvertor;
import cn.zhxu.bs.convertor.NumberParamConvertor;
import cn.zhxu.bs.convertor.StrNumFieldConvertor;
import cn.zhxu.bs.convertor.TimeFieldConvertor;
import cn.zhxu.bs.convertor.TimeParamConvertor;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.dialect.MySqlDialect;
import cn.zhxu.bs.dialect.OracleDialect;
import cn.zhxu.bs.dialect.PostgreSqlDialect;
import cn.zhxu.bs.dialect.SqlServerDialect;
import cn.zhxu.bs.filter.SizeLimitParamFilter;
import cn.zhxu.bs.group.DefaultGroupResolver;
import cn.zhxu.bs.group.DefaultParserFactory;
import cn.zhxu.bs.group.ExprParser;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.implement.DefaultBeanReflector;
import cn.zhxu.bs.implement.DefaultBeanSearcher;
import cn.zhxu.bs.implement.DefaultDbMapping;
import cn.zhxu.bs.implement.DefaultMapSearcher;
import cn.zhxu.bs.implement.DefaultMetaResolver;
import cn.zhxu.bs.implement.DefaultParamResolver;
import cn.zhxu.bs.implement.DefaultSqlExecutor;
import cn.zhxu.bs.implement.DefaultSqlResolver;
import cn.zhxu.bs.implement.PageOffsetExtractor;
import cn.zhxu.bs.implement.PageSizeExtractor;
import cn.zhxu.bs.solon.BeanSearcherProperties;
import cn.zhxu.bs.solon.IllegalConfigException;
import cn.zhxu.bs.solon.NamedDataSource;
import cn.zhxu.bs.util.Cache;
import cn.zhxu.bs.util.LRUCache;
import cn.zhxu.xjson.JsonKit;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AopContext;

@Configuration
public class BeanSearcherAutoConfiguration {
    @Inject
    AopContext context;
    @Inject
    BeanSearcherProperties config;

    @Bean
    @Condition(onMissingBean=PageExtractor.class)
    public PageExtractor pageExtractor() {
        PageSizeExtractor extractor;
        PageSizeExtractor p;
        BeanSearcherProperties.Params.Pagination conf = this.config.getParams().getPagination();
        String type = conf.getType();
        if ("page".equals(type)) {
            p = new PageSizeExtractor();
            p.setPageName(conf.getPage());
            extractor = p;
        } else if ("offset".equals(type)) {
            p = new PageOffsetExtractor();
            p.setOffsetName(conf.getOffset());
            extractor = p;
        } else {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.type: " + type + "], only 'page' / 'offset' allowed.");
        }
        int defaultSize = conf.getDefaultSize();
        int maxAllowedSize = conf.getMaxAllowedSize();
        long maxAllowedOffset = conf.getMaxAllowedOffset();
        if (defaultSize > maxAllowedSize) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] can not greater than [bean-searcher.params.pagination.max-allowed-size: " + maxAllowedSize + "].");
        }
        if (defaultSize < 1) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] must greater equal 1");
        }
        if (maxAllowedOffset < 1L) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.max-allowed-offset: " + maxAllowedOffset + "] must greater equal 1");
        }
        extractor.setMaxAllowedSize(maxAllowedSize);
        extractor.setMaxAllowedOffset(maxAllowedOffset);
        extractor.setDefaultSize(defaultSize);
        extractor.setSizeName(conf.getSize());
        extractor.setStart(conf.getStart());
        return extractor;
    }

    @Bean
    @Condition(onMissingBean=Dialect.class)
    public Dialect dialect() {
        BeanSearcherProperties.Sql.Dialect dialect = this.config.getSql().getDialect();
        if (dialect == null) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.sql.dialect] can not be null.");
        }
        switch (dialect) {
            case MySQL: {
                return new MySqlDialect();
            }
            case Oracle: {
                return new OracleDialect();
            }
            case PostgreSQL: 
            case PgSQL: {
                return new PostgreSqlDialect();
            }
            case SqlServer: {
                return new SqlServerDialect();
            }
        }
        throw new IllegalConfigException("Invalid config: [bean-searcher.sql.dialect: " + (Object)((Object)dialect) + "] only `MySql` / `Oracle` / `PostgreSQL` / `SqlServer` allowed. Please see https://bs.zhxu.cn/guide/latest/advance.html#sql-%E6%96%B9%E8%A8%80%EF%BC%88dialect%EF%BC%89 for help.");
    }

    @Bean
    @Condition(onMissingBean=FieldOpPool.class)
    public FieldOpPool fieldOpPool(Dialect dialect) {
        List fieldOps = this.context.getBeansOfType(FieldOp.class);
        FieldOpPool pool = new FieldOpPool();
        this.ifAvailable(fieldOps, ops -> ops.forEach(arg_0 -> ((FieldOpPool)pool).addFieldOp(arg_0)));
        pool.setDialect(dialect);
        return pool;
    }

    @Bean
    @Condition(onMissingBean=ExprParser.Factory.class)
    public ExprParser.Factory parserFactory() {
        return new DefaultParserFactory();
    }

    @Bean
    @Condition(onMissingBean=GroupResolver.class)
    public GroupResolver groupResolver(ExprParser.Factory parserFactory) {
        DefaultGroupResolver groupResolver = new DefaultGroupResolver();
        BeanSearcherProperties.Params.Group conf = this.config.getParams().getGroup();
        groupResolver.setEnabled(conf.isEnable());
        groupResolver.setCache((Cache)new LRUCache(conf.getCacheSize()));
        groupResolver.setMaxExprLength(conf.getMaxExprLength());
        groupResolver.setParserFactory(parserFactory);
        return groupResolver;
    }

    @Bean
    @Condition(onMissingBean=BoolParamConvertor.class)
    public BoolParamConvertor boolParamConvertor() {
        return new BoolParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=NumberParamConvertor.class)
    public NumberParamConvertor numberParamConvertor() {
        return new NumberParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=DateParamConvertor.class)
    public DateParamConvertor dateParamConvertor() {
        return new DateParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=TimeParamConvertor.class)
    public TimeParamConvertor timeParamConvertor() {
        return new TimeParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=DateTimeParamConvertor.class)
    public DateTimeParamConvertor dateTimeParamConvertor() {
        return new DateTimeParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=SizeLimitParamFilter.class)
    public SizeLimitParamFilter sizeLimitParamFilter() {
        return new SizeLimitParamFilter(this.config.getParams().getFilter().getMaxParaMapSize());
    }

    @Bean
    @Condition(onMissingBean=ParamResolver.class)
    public ParamResolver paramResolver(PageExtractor pageExtractor, FieldOpPool fieldOpPool, List<ParamFilter> paramFilters, List<ParamResolver.Convertor> convertors, GroupResolver groupResolver) {
        DefaultParamResolver paramResolver = new DefaultParamResolver(convertors, paramFilters);
        paramResolver.setPageExtractor(pageExtractor);
        paramResolver.setFieldOpPool(fieldOpPool);
        BeanSearcherProperties.Params conf = this.config.getParams();
        paramResolver.setOperatorSuffix(conf.getOperatorKey());
        paramResolver.setIgnoreCaseSuffix(conf.getIgnoreCaseKey());
        paramResolver.setOrderName(conf.getOrder());
        paramResolver.setSortName(conf.getSort());
        paramResolver.setOrderByName(conf.getOrderBy());
        paramResolver.setSeparator(conf.getSeparator());
        paramResolver.setOnlySelectName(conf.getOnlySelect());
        paramResolver.setSelectExcludeName(conf.getSelectExclude());
        BeanSearcherProperties.Params.Group group = conf.getGroup();
        paramResolver.setGexprName(group.getExprName());
        paramResolver.setGroupSeparator(group.getSeparator());
        paramResolver.setGroupResolver(groupResolver);
        return paramResolver;
    }

    @Bean
    @Condition(onMissingBean=SqlResolver.class)
    public SqlResolver sqlResolver(Dialect dialect) {
        return new DefaultSqlResolver(dialect);
    }

    @Bean
    @Condition(onMissingBean=SqlExecutor.class)
    public SqlExecutor sqlExecutor() {
        DataSource dataSource = (DataSource)this.context.getBean(DataSource.class);
        List namedDataSources = this.context.getBeansOfType(NamedDataSource.class);
        SqlExecutor.SlowListener slowListener = (SqlExecutor.SlowListener)this.context.getBean(SqlExecutor.SlowListener.class);
        DefaultSqlExecutor executor = new DefaultSqlExecutor(dataSource);
        this.ifAvailable(namedDataSources, ndsList -> {
            for (NamedDataSource nds : ndsList) {
                executor.setDataSource(nds.getName(), nds.getDataSource());
            }
        });
        this.ifAvailable(slowListener, arg_0 -> ((DefaultSqlExecutor)executor).setSlowListener(arg_0));
        executor.setSlowSqlThreshold(this.config.getSql().getSlowSqlThreshold());
        return executor;
    }

    @Bean
    @Condition(onMissingBean=NumberFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-number:true}=true")
    public NumberFieldConvertor numberFieldConvertor() {
        return new NumberFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=StrNumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-str-num:true}=true")
    public StrNumFieldConvertor strNumFieldConvertor() {
        return new StrNumFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=BoolNumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-bool-num:true}=true")
    public BoolNumFieldConvertor boolNumFieldConvertor() {
        return new BoolNumFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=BoolFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-bool:true}=true")
    public BoolFieldConvertor boolFieldConvertor() {
        String[] falseValues = this.config.getFieldConvertor().getBoolFalseValues();
        BoolFieldConvertor convertor = new BoolFieldConvertor();
        if (falseValues != null) {
            convertor.addFalseValues(falseValues);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=DateFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-date:true}=true")
    public DateFieldConvertor dateFieldConvertor() {
        DateFieldConvertor convertor = new DateFieldConvertor();
        ZoneId zoneId = this.config.getFieldConvertor().getZoneId();
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=TimeFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-time:true}=true")
    public TimeFieldConvertor timeFieldConvertor() {
        return new TimeFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=EnumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-enum:true}=true")
    public EnumFieldConvertor enumFieldConvertor() {
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        EnumFieldConvertor convertor = new EnumFieldConvertor();
        convertor.setFailOnError(conf.isEnumFailOnError());
        convertor.setIgnoreCase(conf.isEnumIgnoreCase());
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=ListFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-list:true}=true")
    public ListFieldConvertor listFieldConvertor() {
        List tmp = this.context.getBeansOfType(ListFieldConvertor.Convertor.class);
        ArrayList convertorsProvider = new ArrayList();
        tmp.forEach(c -> convertorsProvider.add(c));
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        ListFieldConvertor convertor = new ListFieldConvertor(conf.getListItemSeparator());
        this.ifAvailable(convertorsProvider, arg_0 -> ((ListFieldConvertor)convertor).setConvertors(arg_0));
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=BeanReflector.class)
    public BeanReflector beanReflector() {
        List convertorsProvider = this.context.getBeansOfType(FieldConvertor.BFieldConvertor.class);
        if (convertorsProvider != null) {
            return new DefaultBeanReflector(convertorsProvider);
        }
        return new DefaultBeanReflector();
    }

    @Bean
    @Condition(onMissingBean=DbMapping.class)
    public DbMapping dbMapping() {
        DefaultDbMapping mapping = new DefaultDbMapping();
        BeanSearcherProperties.Sql.DefaultMapping conf = this.config.getSql().getDefaultMapping();
        mapping.setTablePrefix(conf.getTablePrefix());
        mapping.setUpperCase(conf.isUpperCase());
        mapping.setUnderlineCase(conf.isUnderlineCase());
        mapping.setRedundantSuffixes(conf.getRedundantSuffixes());
        mapping.setIgnoreFields(conf.getIgnoreFields());
        mapping.setDefaultInheritType(conf.getInheritType());
        mapping.setDefaultSortType(conf.getSortType());
        mapping.setAroundChar(conf.getAroundChar());
        return mapping;
    }

    @Bean
    @Condition(onMissingBean=MetaResolver.class)
    public MetaResolver metaResolver(DbMapping dbMapping) {
        SnippetResolver snippetResolver = (SnippetResolver)this.context.getBean(SnippetResolver.class);
        DefaultMetaResolver metaResolver = new DefaultMetaResolver(dbMapping);
        this.ifAvailable(snippetResolver, arg_0 -> ((DefaultMetaResolver)metaResolver).setSnippetResolver(arg_0));
        return metaResolver;
    }

    @Bean
    @Condition(onMissingBean=BeanSearcher.class, onProperty="${bean-searcher.use-bean-searcher:true}=true")
    public BeanSearcher beanSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, BeanReflector beanReflector) {
        List interceptors = this.context.getBeansOfType(SqlInterceptor.class);
        List processors = this.context.getBeansOfType(ResultFilter.class);
        DefaultBeanSearcher searcher = new DefaultBeanSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        searcher.setBeanReflector(beanReflector);
        this.ifAvailable(interceptors, arg_0 -> ((DefaultBeanSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(processors, arg_0 -> ((DefaultBeanSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    @Bean
    @Condition(onMissingBean=DateFormatFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-date-format:true}=true")
    public DateFormatFieldConvertor dateFormatFieldConvertor() {
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        Map<String, String> dateFormats = conf.getDateFormats();
        ZoneId zoneId = conf.getZoneId();
        DateFormatFieldConvertor convertor = new DateFormatFieldConvertor();
        if (dateFormats != null) {
            dateFormats.forEach((key, value) -> {
                String scope = key.replace('-', ':');
                convertor.setFormat(scope, value);
            });
        }
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=B2MFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-b2-m}=true")
    public B2MFieldConvertor b2mFieldConvertor() {
        List convertors = this.context.getBeansOfType(FieldConvertor.BFieldConvertor.class);
        if (convertors != null) {
            return new B2MFieldConvertor(convertors);
        }
        return new B2MFieldConvertor(Collections.emptyList());
    }

    @Bean
    @Condition(onMissingBean=MapSearcher.class, onProperty="${bean-searcher.use-map-searcher:true}=true")
    public MapSearcher mapSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor) {
        List convertors = this.context.getBeansOfType(FieldConvertor.MFieldConvertor.class);
        List interceptors = this.context.getBeansOfType(SqlInterceptor.class);
        List resultFilters = this.context.getBeansOfType(ResultFilter.class);
        DefaultMapSearcher searcher = new DefaultMapSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        if (convertors != null) {
            ArrayList newList = new ArrayList(convertors);
            newList.sort((o1, o2) -> {
                if (o1 instanceof DateFormatFieldConvertor) {
                    return -1;
                }
                if (o2 instanceof DateFormatFieldConvertor) {
                    return 1;
                }
                return 0;
            });
            searcher.setConvertors(newList);
        }
        this.ifAvailable(interceptors, arg_0 -> ((DefaultMapSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(resultFilters, arg_0 -> ((DefaultMapSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    @Bean
    @Condition(onClass=JsonKit.class, onProperty="${bean-searcher.field-convertor.use-json:true}=true")
    public JsonFieldConvertor jsonFieldConvertor() {
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        return new JsonFieldConvertor(conf.isJsonFailOnError());
    }

    private <T> void ifAvailable(T provider, Consumer<T> consumer) {
        if (provider != null) {
            consumer.accept(provider);
        }
    }
}

