/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.solon;

import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.MetaResolver;
import cn.zhxu.bs.PageExtractor;
import cn.zhxu.bs.SnippetResolver;
import cn.zhxu.bs.SqlResolver;
import cn.zhxu.bs.convertor.BoolFieldConvertor;
import cn.zhxu.bs.convertor.BoolNumFieldConvertor;
import cn.zhxu.bs.convertor.BoolParamConvertor;
import cn.zhxu.bs.convertor.DateFieldConvertor;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.convertor.DateParamConvertor;
import cn.zhxu.bs.convertor.DateTimeParamConvertor;
import cn.zhxu.bs.convertor.EnumFieldConvertor;
import cn.zhxu.bs.convertor.EnumParamConvertor;
import cn.zhxu.bs.convertor.JsonFieldConvertor;
import cn.zhxu.bs.convertor.ListFieldConvertor;
import cn.zhxu.bs.convertor.NumberFieldConvertor;
import cn.zhxu.bs.convertor.NumberParamConvertor;
import cn.zhxu.bs.convertor.StrNumFieldConvertor;
import cn.zhxu.bs.convertor.TimeFieldConvertor;
import cn.zhxu.bs.convertor.TimeParamConvertor;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.dialect.DynamicDialect;
import cn.zhxu.bs.dialect.DynamicDialectSupport;
import cn.zhxu.bs.dialect.MySqlDialect;
import cn.zhxu.bs.dialect.OracleDialect;
import cn.zhxu.bs.dialect.PostgreSqlDialect;
import cn.zhxu.bs.dialect.SqlServerDialect;
import cn.zhxu.bs.filter.SizeLimitParamFilter;
import cn.zhxu.bs.group.DefaultGroupResolver;
import cn.zhxu.bs.group.DefaultParserFactory;
import cn.zhxu.bs.group.ExprParser;
import cn.zhxu.bs.group.GroupPair;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.implement.DefaultDbMapping;
import cn.zhxu.bs.implement.DefaultMetaResolver;
import cn.zhxu.bs.implement.DefaultSqlResolver;
import cn.zhxu.bs.implement.GroupPairResolver;
import cn.zhxu.bs.implement.PageOffsetExtractor;
import cn.zhxu.bs.implement.PageSizeExtractor;
import cn.zhxu.bs.solon.BeanSearcherProperties;
import cn.zhxu.bs.solon.DataSourceDialect;
import cn.zhxu.bs.solon.IllegalConfigException;
import cn.zhxu.bs.util.Cache;
import cn.zhxu.bs.util.LRUCache;
import cn.zhxu.xjson.JsonKit;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AppContext;

@Configuration
public class ConfigurationBefore {
    @Inject
    AppContext context;
    @Inject
    BeanSearcherProperties config;

    @Bean
    @Condition(onMissingBean=BoolParamConvertor.class)
    public BoolParamConvertor boolParamConvertor() {
        return new BoolParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=NumberParamConvertor.class)
    public NumberParamConvertor numberParamConvertor() {
        return new NumberParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=DateParamConvertor.class)
    public DateParamConvertor dateParamConvertor() {
        return new DateParamConvertor(this.config.getParams().getConvertor().getDateTarget());
    }

    @Bean
    @Condition(onMissingBean=TimeParamConvertor.class)
    public TimeParamConvertor timeParamConvertor() {
        return new TimeParamConvertor(this.config.getParams().getConvertor().getTimeTarget());
    }

    @Bean
    @Condition(onMissingBean=DateTimeParamConvertor.class)
    public DateTimeParamConvertor dateTimeParamConvertor() {
        return new DateTimeParamConvertor(this.config.getParams().getConvertor().getDateTimeTarget());
    }

    @Bean
    @Condition(onMissingBean=EnumParamConvertor.class)
    public EnumParamConvertor enumParamConvertor() {
        return new EnumParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=SizeLimitParamFilter.class)
    public SizeLimitParamFilter sizeLimitParamFilter() {
        return new SizeLimitParamFilter(this.config.getParams().getFilter().getMaxParaMapSize());
    }

    @Bean
    @Condition(onMissingBean=PageExtractor.class)
    public PageExtractor pageExtractor() {
        PageSizeExtractor extractor;
        PageSizeExtractor p;
        BeanSearcherProperties.Params.Pagination conf = this.config.getParams().getPagination();
        String type = conf.getType();
        if ("page".equals(type)) {
            p = new PageSizeExtractor();
            p.setPageName(conf.getPage());
            extractor = p;
        } else if ("offset".equals(type)) {
            p = new PageOffsetExtractor();
            p.setOffsetName(conf.getOffset());
            extractor = p;
        } else {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.type: " + type + "], only 'page' / 'offset' allowed.");
        }
        int defaultSize = conf.getDefaultSize();
        int maxAllowedSize = conf.getMaxAllowedSize();
        long maxAllowedOffset = conf.getMaxAllowedOffset();
        if (defaultSize > maxAllowedSize) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] can not greater than [bean-searcher.params.pagination.max-allowed-size: " + maxAllowedSize + "].");
        }
        if (defaultSize < 1) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] must greater equal 1");
        }
        if (maxAllowedOffset < 1L) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.max-allowed-offset: " + maxAllowedOffset + "] must greater equal 1");
        }
        extractor.setMaxAllowedSize(maxAllowedSize);
        extractor.setMaxAllowedOffset(maxAllowedOffset);
        extractor.setDefaultSize(defaultSize);
        extractor.setSizeName(conf.getSize());
        extractor.setStart(conf.getStart());
        return extractor;
    }

    @Bean
    @Condition(onMissingBean=Dialect.class)
    public Dialect dialect() {
        BeanSearcherProperties.Sql conf = this.config.getSql();
        BeanSearcherProperties.Sql.Dialect defaultType = conf.getDialect();
        if (defaultType == null) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.sql.dialect] can not be null.");
        }
        Dialect defaultDialect = this.createDialect(defaultType, "dialect");
        if (conf.isDialectDynamic()) {
            DynamicDialect dynamicDialect = new DynamicDialect();
            dynamicDialect.setDefaultDialect(defaultDialect);
            List dialects = this.context.getBeansOfType(DataSourceDialect.class);
            dialects.forEach(item -> dynamicDialect.put(item.getDataSource(), item.getDialect()));
            conf.getDialects().forEach((ds, dType) -> dynamicDialect.put(ds, this.createDialect((BeanSearcherProperties.Sql.Dialect)((Object)dType), "dialects." + ds)));
            return dynamicDialect;
        }
        return defaultDialect;
    }

    private Dialect createDialect(BeanSearcherProperties.Sql.Dialect dialectType, String propKey) {
        switch (dialectType) {
            case MySQL: {
                return new MySqlDialect();
            }
            case Oracle: {
                return new OracleDialect();
            }
            case PostgreSQL: 
            case PgSQL: {
                return new PostgreSqlDialect();
            }
            case SqlServer: {
                return new SqlServerDialect();
            }
        }
        throw new IllegalConfigException("Invalid config: [bean-searcher.sql." + propKey + ": " + (Object)((Object)dialectType) + "]. Please see https://bs.zhxu.cn/guide/latest/advance.html#sql-%E6%96%B9%E8%A8%80%EF%BC%88dialect%EF%BC%89 for help.");
    }

    @Bean
    @Condition(onMissingBean=DynamicDialectSupport.class, onProperty="${bean-searcher.sql.dialect-dynamic}=true")
    public DynamicDialectSupport dynamicDialectSupport() {
        return new DynamicDialectSupport();
    }

    @Bean
    @Condition(onMissingBean=ExprParser.Factory.class)
    public ExprParser.Factory parserFactory() {
        return new DefaultParserFactory();
    }

    @Bean
    @Condition(onMissingBean=GroupResolver.class)
    public GroupResolver groupResolver(ExprParser.Factory parserFactory) {
        DefaultGroupResolver groupResolver = new DefaultGroupResolver();
        BeanSearcherProperties.Params.Group conf = this.config.getParams().getGroup();
        groupResolver.setEnabled(conf.isEnable());
        groupResolver.setCache((Cache)new LRUCache(conf.getCacheSize()));
        groupResolver.setMaxExprLength(conf.getMaxExprLength());
        groupResolver.setParserFactory(parserFactory);
        return groupResolver;
    }

    @Bean
    @Condition(onMissingBean=GroupPair.Resolver.class)
    public GroupPair.Resolver groupPairResolver() {
        return new GroupPairResolver();
    }

    @Bean
    @Condition(onMissingBean=SqlResolver.class)
    public SqlResolver sqlResolver(Dialect dialect, GroupPair.Resolver groupPairResolver) {
        DefaultSqlResolver resolver = new DefaultSqlResolver(dialect);
        resolver.setGroupPairResolver(groupPairResolver);
        return resolver;
    }

    @Bean
    @Condition(onMissingBean=NumberFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-number:true}=true")
    public NumberFieldConvertor numberFieldConvertor() {
        return new NumberFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=StrNumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-str-num:true}=true")
    public StrNumFieldConvertor strNumFieldConvertor() {
        return new StrNumFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=BoolNumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-bool-num:true}=true")
    public BoolNumFieldConvertor boolNumFieldConvertor() {
        return new BoolNumFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=BoolFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-bool:true}=true")
    public BoolFieldConvertor boolFieldConvertor() {
        String[] falseValues = this.config.getFieldConvertor().getBoolFalseValues();
        BoolFieldConvertor convertor = new BoolFieldConvertor();
        if (falseValues != null) {
            convertor.addFalseValues(falseValues);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=DateFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-date:true}=true")
    public DateFieldConvertor dateFieldConvertor() {
        DateFieldConvertor convertor = new DateFieldConvertor();
        ZoneId zoneId = this.config.getFieldConvertor().getZoneId();
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=TimeFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-time:true}=true")
    public TimeFieldConvertor timeFieldConvertor() {
        return new TimeFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=EnumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-enum:true}=true")
    public EnumFieldConvertor enumFieldConvertor() {
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        EnumFieldConvertor convertor = new EnumFieldConvertor();
        convertor.setFailOnError(conf.isEnumFailOnError());
        convertor.setIgnoreCase(conf.isEnumIgnoreCase());
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=JsonFieldConvertor.class, onClass=JsonKit.class, onProperty="${bean-searcher.field-convertor.use-json:true}=true")
    public JsonFieldConvertor jsonFieldConvertor() {
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        return new JsonFieldConvertor(conf.isJsonFailOnError());
    }

    @Bean
    @Condition(onMissingBean=ListFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-list:true}=true")
    public ListFieldConvertor listFieldConvertor() {
        List tmp = this.context.getBeansOfType(ListFieldConvertor.Convertor.class);
        ArrayList convertors = new ArrayList();
        tmp.forEach(convertors::add);
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        ListFieldConvertor convertor = new ListFieldConvertor(conf.getListItemSeparator());
        if (convertors != null) {
            convertor.setConvertors(convertors);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=DbMapping.class)
    public DbMapping dbMapping() {
        DefaultDbMapping mapping = new DefaultDbMapping();
        BeanSearcherProperties.Sql.DefaultMapping conf = this.config.getSql().getDefaultMapping();
        mapping.setTablePrefix(conf.getTablePrefix());
        mapping.setUpperCase(conf.isUpperCase());
        mapping.setUnderlineCase(conf.isUnderlineCase());
        mapping.setRedundantSuffixes(conf.getRedundantSuffixes());
        mapping.setIgnoreFields(conf.getIgnoreFields());
        mapping.setDefaultInheritType(conf.getInheritType());
        mapping.setDefaultSortType(conf.getSortType());
        mapping.setAroundChar(conf.getAroundChar());
        return mapping;
    }

    @Bean
    @Condition(onMissingBean=MetaResolver.class)
    public MetaResolver metaResolver(DbMapping dbMapping) {
        SnippetResolver snippetResolver = (SnippetResolver)this.context.getBean(SnippetResolver.class);
        DefaultMetaResolver metaResolver = new DefaultMetaResolver(dbMapping);
        if (snippetResolver != null) {
            metaResolver.setSnippetResolver(snippetResolver);
        }
        return metaResolver;
    }

    @Bean
    @Condition(onMissingBean=DateFormatFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-date-format:true}=true")
    public DateFormatFieldConvertor dateFormatFieldConvertor() {
        BeanSearcherProperties.FieldConvertor conf = this.config.getFieldConvertor();
        Map<String, String> dateFormats = conf.getDateFormats();
        ZoneId zoneId = conf.getZoneId();
        DateFormatFieldConvertor convertor = new DateFormatFieldConvertor();
        if (dateFormats != null) {
            dateFormats.forEach((key, value) -> {
                String scope = key.replace('-', ':');
                convertor.setFormat(scope, value);
            });
        }
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }
}

