/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.beetlsql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.DefaultConnectionSource;
import org.beetl.sql.core.ExecuteContext;
import org.noear.solon.core.XTranUtils;

public class SQLConnectionSource
extends DefaultConnectionSource {
    public SQLConnectionSource(DataSource master, DataSource[] slaves) {
        super(master, slaves);
    }

    public Connection getConn(ExecuteContext ctx, boolean isUpdate) {
        boolean isReadOnly;
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(ctx);
        }
        if (isUpdate) {
            return this.getWriteConn(ctx);
        }
        if (this.isTransaction() && !(isReadOnly = XTranUtils.inTransAndReadOnly())) {
            return this.getWriteConn(ctx);
        }
        return this.getReadConn(ctx);
    }

    protected Connection doGetConnection(DataSource ds) {
        try {
            return XTranUtils.getConnection((DataSource)ds);
        }
        catch (SQLException e) {
            throw new BeetlSQLException(0, (Throwable)e);
        }
    }

    public boolean isTransaction() {
        return XTranUtils.inTrans();
    }
}

