/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.beetlsql;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.beetl.sql.core.ConditionalSQLManager;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XEventBus;
import org.noear.solon.extend.beetlsql.SQLConnectionSource;

public class SQLManagerUtils {
    private static final Map<String, SQLManager> cached = new ConcurrentHashMap<String, SQLManager>();
    private static ConditionalSQLManager dynamic;

    private static SQLManager build(BeanWrap bw) {
        SQLConnectionSource cs = null;
        DataSource master = (DataSource)bw.raw();
        if (XUtil.isNotEmpty((String)bw.attrs())) {
            String[] slaveAry = bw.attrs().split(",");
            DataSource[] slaves = new DataSource[slaveAry.length];
            int len = slaveAry.length;
            for (int i = 0; i < len; ++i) {
                slaves[i] = (DataSource)Aop.get((String)slaveAry[i]);
                if (slaves[i] != null) continue;
                throw new RuntimeException("SQLManagerUtils: This data source does not exist: " + slaveAry[i]);
            }
            cs = new SQLConnectionSource(master, slaves);
        } else {
            cs = new SQLConnectionSource(master, null);
        }
        SQLManagerBuilder builder = SQLManager.newBuilder((ConnectionSource)cs);
        XEventBus.push((Object)builder);
        return builder.build();
    }

    public static ConditionalSQLManager dynamicGet() {
        return dynamic;
    }

    public static void dynamicBuild(BeanWrap def) {
        Iterator<Map.Entry<String, SQLManager>> iterator;
        SQLManager master = SQLManagerUtils.get("", def);
        if (master == null && (iterator = cached.entrySet().iterator()).hasNext()) {
            Map.Entry<String, SQLManager> kv = iterator.next();
            master = kv.getValue();
        }
        if (master != null) {
            dynamic = new ConditionalSQLManager(master, cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLManager get(String name, BeanWrap bw) {
        if (bw == null || name == null) {
            return null;
        }
        SQLManager tmp = cached.get(name);
        if (tmp == null) {
            String string = name.intern();
            synchronized (string) {
                tmp = cached.get(name);
                if (tmp == null) {
                    tmp = SQLManagerUtils.build(bw);
                    cached.put(name, tmp);
                }
            }
        }
        return tmp;
    }
}

