/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.beetlsql;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.beetl.sql.core.ConditionalSQLManager;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XEventBus;
import org.noear.solon.extend.beetlsql.DbConnectionSource;

class DbManager {
    private static DbManager _global = new DbManager();
    private final Map<String, SQLManager> cached = new ConcurrentHashMap<String, SQLManager>();
    private ConditionalSQLManager dynamic;

    DbManager() {
    }

    public static DbManager global() {
        return _global;
    }

    private SQLManager build(BeanWrap bw) {
        DbConnectionSource cs = null;
        DataSource master = (DataSource)bw.raw();
        if (XUtil.isNotEmpty((String)bw.attrs())) {
            String[] slaveAry = bw.attrs().split(",");
            DataSource[] slaves = new DataSource[slaveAry.length];
            int len = slaveAry.length;
            for (int i = 0; i < len; ++i) {
                slaves[i] = (DataSource)Aop.get((String)slaveAry[i]);
                if (slaves[i] != null) continue;
                throw new RuntimeException("SQLManagerUtils: This data source does not exist: " + slaveAry[i]);
            }
            cs = new DbConnectionSource(master, slaves);
        } else {
            cs = new DbConnectionSource(master, null);
        }
        SQLManagerBuilder builder = SQLManager.newBuilder((ConnectionSource)cs);
        XEventBus.push((Object)builder);
        return builder.build();
    }

    public ConditionalSQLManager dynamicGet() {
        return this.dynamic;
    }

    public void dynamicBuild(BeanWrap def) {
        Iterator<Map.Entry<String, SQLManager>> iterator;
        SQLManager master = this.get(def);
        if (master == null && (iterator = this.cached.entrySet().iterator()).hasNext()) {
            Map.Entry<String, SQLManager> kv = iterator.next();
            master = kv.getValue();
        }
        if (master != null) {
            this.dynamic = new ConditionalSQLManager(master, this.cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLManager get(BeanWrap bw) {
        if (bw == null) {
            return null;
        }
        SQLManager tmp = this.cached.get(bw.name());
        if (tmp == null) {
            String string = bw.name().intern();
            synchronized (string) {
                tmp = this.cached.get(bw.name());
                if (tmp == null) {
                    tmp = this.build(bw);
                    this.cached.put(bw.name(), tmp);
                }
            }
        }
        return tmp;
    }

    public void reg(BeanWrap bw) {
        this.get(bw);
    }
}

