/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.beetlsql;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.beetl.sql.core.ConditionalSQLManager;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.db.DB2SqlStyle;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.H2Style;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.db.OracleStyle;
import org.beetl.sql.core.db.PolarDBStyle;
import org.beetl.sql.core.db.PostgresStyle;
import org.beetl.sql.core.db.SQLiteStyle;
import org.beetl.sql.core.db.SqlServer2012Style;
import org.beetl.sql.core.db.SqlServerStyle;
import org.beetl.sql.core.nosql.CassandraSqlStyle;
import org.beetl.sql.core.nosql.ClickHouseStyle;
import org.beetl.sql.core.nosql.CouchBaseStyle;
import org.beetl.sql.core.nosql.DrillStyle;
import org.beetl.sql.core.nosql.DruidStyle;
import org.beetl.sql.core.nosql.HBaseStyle;
import org.beetl.sql.core.nosql.HiveStyle;
import org.beetl.sql.core.nosql.IgniteStyle;
import org.beetl.sql.core.nosql.ImpalaStyle;
import org.beetl.sql.core.nosql.MachbaseStyle;
import org.beetl.sql.core.nosql.PrestoStyle;
import org.beetl.sql.core.nosql.TaosStyle;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.ValHolder;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.beetlsql.DbConnectionSource;

public class DbManager {
    private static final String TAG = "beetlsql";
    private static final String ATTR_dialect = "dialect";
    private static final String ATTR_slaves = "slaves";
    private static final String ATTR_dev = "dev";
    private static final Map<String, SQLManager> cached = new ConcurrentHashMap<String, SQLManager>();
    private static ConditionalSQLManager dynamic;

    public static ConditionalSQLManager dynamicGet() {
        return dynamic;
    }

    public static void dynamicBuild(BeanWrap def) {
        Iterator<Map.Entry<String, SQLManager>> iterator;
        SQLManager master = DbManager.get(def);
        if (master == null && (iterator = cached.entrySet().iterator()).hasNext()) {
            Map.Entry<String, SQLManager> kv = iterator.next();
            master = kv.getValue();
        }
        if (master != null) {
            dynamic = new ConditionalSQLManager(master, cached);
        }
    }

    public static SQLManager get(String dsName) {
        BeanWrap dsWrap = Solon.context().getWrap((Object)dsName);
        return DbManager.get(dsWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLManager get(BeanWrap dsWrap) {
        if (dsWrap == null) {
            return null;
        }
        SQLManager tmp = cached.get(dsWrap.name());
        if (tmp == null) {
            String string = dsWrap.name().intern();
            synchronized (string) {
                tmp = cached.get(dsWrap.name());
                if (tmp == null) {
                    tmp = DbManager.build(dsWrap);
                    cached.put(dsWrap.name(), tmp);
                }
            }
        }
        return tmp;
    }

    public static void reg(BeanWrap bw) {
        DbManager.get(bw);
    }

    private static SQLManager build(BeanWrap bw) {
        DbConnectionSource cs = null;
        DataSource master = (DataSource)bw.raw();
        Props dsProps = Utils.isNotEmpty((String)bw.name()) ? bw.context().getProps().getProp("beetlsql." + bw.name()) : new Props();
        String slaves_str = dsProps.get(ATTR_slaves);
        dsProps.remove((Object)ATTR_slaves);
        if (Utils.isEmpty((String)slaves_str)) {
            slaves_str = bw.attrGet(ATTR_slaves);
        }
        if (Utils.isNotEmpty((String)slaves_str)) {
            String[] slaveAry = slaves_str.split(",");
            DataSource[] slaves = new DataSource[slaveAry.length];
            int len = slaveAry.length;
            for (int i = 0; i < len; ++i) {
                ValHolder valHolder = new ValHolder((Object)i);
                bw.context().getWrapAsyn((Object)slaveAry[i], dsBw -> {
                    slaves[((Integer)valHolder.value).intValue()] = (DataSource)dsBw.raw();
                });
            }
            cs = new DbConnectionSource(master, slaves);
        } else {
            cs = new DbConnectionSource(master, null);
        }
        String dialect_str = dsProps.get(ATTR_dialect);
        dsProps.remove((Object)ATTR_dialect);
        if (Utils.isEmpty((String)slaves_str)) {
            dialect_str = bw.attrGet(ATTR_dialect);
        }
        SQLManagerBuilder builder = SQLManager.newBuilder((ConnectionSource)cs);
        String dataSourceId = "ds-" + (bw.name() == null ? "" : bw.name());
        builder.setName(dataSourceId);
        DbManager.buildStyle(builder, dialect_str);
        if (dsProps.size() > 0) {
            if (dsProps.getBool(ATTR_dev, false)) {
                builder.addInterDebug();
            }
            dsProps.remove((Object)ATTR_dev);
            Utils.injectProperties((Object)builder, (Properties)dsProps);
        }
        EventBus.push((Object)builder);
        return builder.build();
    }

    private static void buildStyle(SQLManagerBuilder builder, String dialect) {
        if (Utils.isNotEmpty((String)dialect)) {
            DBStyle style = null;
            if (dialect.indexOf(".") > 0) {
                style = (DBStyle)Utils.newInstance((String)dialect);
            } else {
                switch (dialect = dialect.toLowerCase()) {
                    case "oracle": {
                        style = new OracleStyle();
                        break;
                    }
                    case "mysql": {
                        style = new MySqlStyle();
                        break;
                    }
                    case "sqlserver": {
                        style = new SqlServerStyle();
                        break;
                    }
                    case "sqlserver2012": {
                        style = new SqlServer2012Style();
                        break;
                    }
                    case "postgres": 
                    case "postgresql": 
                    case "pgsql": {
                        style = new PostgresStyle();
                        break;
                    }
                    case "db2": {
                        style = new DB2SqlStyle();
                        break;
                    }
                    case "h2": {
                        style = new H2Style();
                        break;
                    }
                    case "sqlite": {
                        style = new SQLiteStyle();
                        break;
                    }
                    case "polardb": {
                        style = new PolarDBStyle();
                        break;
                    }
                    case "cassandra": 
                    case "cassandrasql": {
                        style = new CassandraSqlStyle();
                        break;
                    }
                    case "clickhouse": {
                        style = new ClickHouseStyle();
                        break;
                    }
                    case "couchbase": {
                        style = new CouchBaseStyle();
                        break;
                    }
                    case "drill": {
                        style = new DrillStyle();
                        break;
                    }
                    case "druid": {
                        style = new DruidStyle();
                        break;
                    }
                    case "hbase": {
                        style = new HBaseStyle();
                        break;
                    }
                    case "hive": {
                        style = new HiveStyle();
                        break;
                    }
                    case "ignite": {
                        style = new IgniteStyle();
                        break;
                    }
                    case "impala": {
                        style = new ImpalaStyle();
                        break;
                    }
                    case "machbase": {
                        style = new MachbaseStyle();
                        break;
                    }
                    case "presto": {
                        style = new PrestoStyle();
                        break;
                    }
                    case "taos": {
                        style = new TaosStyle();
                    }
                }
            }
            if (style != null) {
                builder.setDbStyle(style);
            }
        }
    }
}

