/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.beetlsql;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.beetl.sql.core.ConditionalSQLManager;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.db.DB2SqlStyle;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.H2Style;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.db.OracleStyle;
import org.beetl.sql.core.db.PolarDBStyle;
import org.beetl.sql.core.db.PostgresStyle;
import org.beetl.sql.core.db.SQLiteStyle;
import org.beetl.sql.core.db.SqlServer2012Style;
import org.beetl.sql.core.db.SqlServerStyle;
import org.beetl.sql.core.nosql.CassandraSqlStyle;
import org.beetl.sql.core.nosql.ClickHouseStyle;
import org.beetl.sql.core.nosql.CouchBaseStyle;
import org.beetl.sql.core.nosql.DrillStyle;
import org.beetl.sql.core.nosql.DruidStyle;
import org.beetl.sql.core.nosql.HBaseStyle;
import org.beetl.sql.core.nosql.HiveStyle;
import org.beetl.sql.core.nosql.IgniteStyle;
import org.beetl.sql.core.nosql.ImpalaStyle;
import org.beetl.sql.core.nosql.MachbaseStyle;
import org.beetl.sql.core.nosql.PrestoStyle;
import org.beetl.sql.core.nosql.TaosStyle;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.beetlsql.DbConnectionSource;

class DbManager {
    private static DbManager _global = new DbManager();
    private final Map<String, SQLManager> cached = new ConcurrentHashMap<String, SQLManager>();
    private ConditionalSQLManager dynamic;

    DbManager() {
    }

    public static DbManager global() {
        return _global;
    }

    private SQLManager build(BeanWrap bw) {
        DbConnectionSource cs = null;
        DataSource master = (DataSource)bw.raw();
        String slaves_str = bw.attrGet("slaves");
        if (Utils.isNotEmpty((String)slaves_str)) {
            String[] slaveAry = slaves_str.split(",");
            DataSource[] slaves = new DataSource[slaveAry.length];
            int len = slaveAry.length;
            for (int i = 0; i < len; ++i) {
                slaves[i] = (DataSource)Aop.get((String)slaveAry[i]);
                if (slaves[i] != null) continue;
                throw new RuntimeException("DbManager: This data source does not exist: " + slaveAry[i]);
            }
            cs = new DbConnectionSource(master, slaves);
        } else {
            cs = new DbConnectionSource(master, null);
        }
        SQLManagerBuilder builder = SQLManager.newBuilder((ConnectionSource)cs);
        this.buildStyle(bw, builder);
        EventBus.push((Object)builder);
        return builder.build();
    }

    public ConditionalSQLManager dynamicGet() {
        return this.dynamic;
    }

    public void dynamicBuild(BeanWrap def) {
        Iterator<Map.Entry<String, SQLManager>> iterator;
        SQLManager master = this.get(def);
        if (master == null && (iterator = this.cached.entrySet().iterator()).hasNext()) {
            Map.Entry<String, SQLManager> kv = iterator.next();
            master = kv.getValue();
        }
        if (master != null) {
            this.dynamic = new ConditionalSQLManager(master, this.cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLManager get(BeanWrap bw) {
        if (bw == null) {
            return null;
        }
        SQLManager tmp = this.cached.get(bw.name());
        if (tmp == null) {
            String string = bw.name().intern();
            synchronized (string) {
                tmp = this.cached.get(bw.name());
                if (tmp == null) {
                    tmp = this.build(bw);
                    this.cached.put(bw.name(), tmp);
                }
            }
        }
        return tmp;
    }

    public void reg(BeanWrap bw) {
        this.get(bw);
    }

    private void buildStyle(BeanWrap bw, SQLManagerBuilder builder) {
        String dialect = bw.attrGet("dialect");
        if (Utils.isNotEmpty((String)dialect)) {
            DBStyle style = null;
            if (dialect.indexOf(".") > 0) {
                style = (DBStyle)Utils.newInstance((String)dialect);
            } else {
                switch (dialect = dialect.toLowerCase()) {
                    case "oracle": {
                        style = new OracleStyle();
                        break;
                    }
                    case "mysql": {
                        style = new MySqlStyle();
                        break;
                    }
                    case "sqlserver": {
                        style = new SqlServerStyle();
                        break;
                    }
                    case "sqlserver2012": {
                        style = new SqlServer2012Style();
                        break;
                    }
                    case "postgres": 
                    case "postgresql": 
                    case "pgsql": {
                        style = new PostgresStyle();
                        break;
                    }
                    case "db2": {
                        style = new DB2SqlStyle();
                        break;
                    }
                    case "h2": {
                        style = new H2Style();
                        break;
                    }
                    case "sqlite": {
                        style = new SQLiteStyle();
                        break;
                    }
                    case "polardb": {
                        style = new PolarDBStyle();
                        break;
                    }
                    case "cassandra": 
                    case "cassandrasql": {
                        style = new CassandraSqlStyle();
                        break;
                    }
                    case "clickhouse": {
                        style = new ClickHouseStyle();
                        break;
                    }
                    case "couchbase": {
                        style = new CouchBaseStyle();
                        break;
                    }
                    case "drill": {
                        style = new DrillStyle();
                        break;
                    }
                    case "druid": {
                        style = new DruidStyle();
                        break;
                    }
                    case "hbase": {
                        style = new HBaseStyle();
                        break;
                    }
                    case "hive": {
                        style = new HiveStyle();
                        break;
                    }
                    case "ignite": {
                        style = new IgniteStyle();
                        break;
                    }
                    case "impala": {
                        style = new ImpalaStyle();
                        break;
                    }
                    case "machbase": {
                        style = new MachbaseStyle();
                        break;
                    }
                    case "presto": {
                        style = new PrestoStyle();
                        break;
                    }
                    case "taos": {
                        style = new TaosStyle();
                    }
                }
            }
            if (style != null) {
                builder.setDbStyle(style);
            }
        }
    }
}

