/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.beetlsql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.DefaultConnectionSource;
import org.beetl.sql.core.ExecuteContext;
import org.noear.solon.data.tran.TranUtils;

class DbConnectionSource
extends DefaultConnectionSource {
    public DbConnectionSource(DataSource master, DataSource[] slaves) {
        super(master, slaves);
    }

    public Connection getConn(ExecuteContext ctx, boolean isUpdate) {
        boolean isReadOnly;
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(ctx);
        }
        if (isUpdate) {
            return this.getWriteConn(ctx);
        }
        if (this.isTransaction() && !(isReadOnly = TranUtils.inTransAndReadOnly())) {
            return this.getWriteConn(ctx);
        }
        return this.getReadConn(ctx);
    }

    protected Connection doGetConnection(ExecuteContext ctx, DataSource ds) {
        try {
            return TranUtils.getConnection((DataSource)ds);
        }
        catch (SQLException e) {
            throw new BeetlSQLException(0, (Throwable)e);
        }
    }

    public boolean isTransaction() {
        return TranUtils.inTrans();
    }
}

