/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.extend.consul.Tools;

class ConsulRegisterTask
implements Runnable {
    ConsulClient client;

    public ConsulRegisterTask(ConsulClient client) {
        this.client = client;
    }

    @Override
    public void run() {
        String healthCheckInterval = Solon.cfg().get("consul.discovery.healthCheckInterval", "10s");
        String healthCheckPath = Solon.cfg().get("consul.discovery.healthCheckPath", "/run/check/");
        String hostname = Solon.cfg().get("consul.discovery.hostname");
        String tags_str = Solon.cfg().get("consul.discovery.tags");
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        tags.add("solon");
        if (Utils.isNotEmpty((String)Solon.cfg().appGroup())) {
            tags.add(Solon.cfg().appGroup());
        }
        if (Utils.isNotEmpty((String)tags_str)) {
            tags.addAll(Arrays.asList(tags_str.split(",")));
        }
        if (Utils.isEmpty((String)hostname)) {
            hostname = Tools.getLocalAddress();
        }
        NewService newService = new NewService();
        newService.setPort(Integer.valueOf(Solon.global().port()));
        newService.setId(Solon.cfg().appName() + "-" + Solon.global().port());
        newService.setName(Solon.cfg().appName());
        newService.setTags(new ArrayList(tags));
        newService.setAddress(hostname);
        if (Utils.isNotEmpty((String)healthCheckInterval)) {
            Solon.global().get(healthCheckPath, ctx -> ctx.output("OK"));
            String checkUrl = "http://" + hostname + ":" + Solon.global().port();
            checkUrl = healthCheckPath.startsWith("/") ? checkUrl + healthCheckPath : checkUrl + "/" + healthCheckPath;
            NewService.Check check = new NewService.Check();
            check.setInterval(healthCheckInterval);
            check.setMethod("GET");
            check.setHttp(checkUrl);
            check.setDeregisterCriticalServiceAfter("60s");
            check.setTimeout("60s");
            newService.setCheck(check);
        }
        this.client.agentServiceRegister(newService);
    }
}

