/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.Utils;

class ConsulConfigTask
extends TimerTask {
    ConsulClient client;
    long configVer = 0L;
    String configKey;

    public ConsulConfigTask(ConsulClient client) {
        this.client = client;
        this.configKey = Solon.cfg().get("consul.config.key");
        if (Utils.isEmpty((String)this.configKey)) {
            this.configKey = Solon.cfg().appGroup();
        }
        if (Utils.isEmpty((String)this.configKey)) {
            this.configKey = Solon.cfg().appName();
        }
    }

    @Override
    public void run() {
        Response v = this.client.getKVValue(this.configKey);
        GetValue gv = (GetValue)v.getValue();
        if (gv != null && gv.getModifyIndex() > this.configVer) {
            this.configVer = gv.getModifyIndex();
            String configValue = gv.getDecodedValue();
            Properties keyValues = Utils.buildProperties((String)configValue);
            if (keyValues != null) {
                Solon.cfg().putAll((Map)keyValues);
            }
        }
    }
}

