/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Service;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.noear.solon.Utils;
import org.noear.solon.extend.consul.LoadBalanceSimple;
import org.noear.solon.extend.consul.LoadBalanceSimpleFactory;

class ConsulLocatorTask
extends TimerTask {
    ConsulClient client;
    LoadBalanceSimpleFactory factory;

    public ConsulLocatorTask(ConsulClient client, LoadBalanceSimpleFactory factory) {
        this.client = client;
        this.factory = factory;
    }

    @Override
    public void run() {
        HashMap<String, LoadBalanceSimple> storage = new HashMap<String, LoadBalanceSimple>();
        Response services = this.client.getAgentServices();
        for (Map.Entry kv : ((Map)services.getValue()).entrySet()) {
            Service service = (Service)kv.getValue();
            if (Utils.isEmpty((String)service.getAddress())) continue;
            String name = service.getService();
            LoadBalanceSimple loadBalance = (LoadBalanceSimple)storage.get(name);
            if (loadBalance == null) {
                loadBalance = new LoadBalanceSimple();
                storage.put(name, loadBalance);
            }
            loadBalance.addServer("http://" + service.getAddress() + ":" + service.getPort());
        }
        this.factory.update(storage);
    }
}

