/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.noear.solon.Solon;
import org.noear.solon.Utils;

class Tools {
    private static String localAddress;

    Tools() {
    }

    public static String getLocalAddress() {
        if (localAddress == null) {
            InetAddress address = Tools.findFirstNonLoopbackAddress();
            localAddress = address.getHostAddress();
        }
        return localAddress;
    }

    private static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                if (Solon.cfg().isDebugMode()) {
                    System.out.println("Testing network interface: " + ifc.getDisplayName());
                }
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            System.err.println("Cannot get first non-loopback address" + ex.getStackTrace());
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.err.println("Unable to retrieve localhost");
            return null;
        }
    }

    public static int getInterval(String val) {
        if (Utils.isEmpty((String)val)) {
            return 0;
        }
        if (val.endsWith("ms")) {
            return Integer.parseInt(val.substring(0, val.length() - 2));
        }
        if (val.endsWith("s")) {
            return Integer.parseInt(val.substring(0, val.length() - 1)) * 1000;
        }
        if (val.indexOf("s") < 0) {
            return Integer.parseInt(val);
        }
        return 0;
    }
}

