/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.consul.ConsulKvUpdateEvent;

class ConsulConfigTask
extends TimerTask {
    ConsulClient client;
    Map<String, Long> watchedIndex = new HashMap<String, Long>();
    long configVer = 0L;
    String token;
    String configKey;
    Set<String> watchKeys = new HashSet<String>();

    public ConsulConfigTask(ConsulClient client) {
        String watchKeys;
        this.client = client;
        this.token = Solon.cfg().get("consul.token");
        this.configKey = Solon.cfg().get("consul.config.key");
        if (Utils.isEmpty((String)this.configKey)) {
            this.configKey = Solon.cfg().appGroup();
        }
        if (Utils.isEmpty((String)this.configKey)) {
            this.configKey = Solon.cfg().appName();
        }
        if (Utils.isNotEmpty((String)(watchKeys = Solon.cfg().get("consul.config.watch")))) {
            this.watchKeys.addAll(Arrays.asList(watchKeys.split(",")));
        }
    }

    @Override
    public void run() {
        Response v = this.client.getKVValue(this.configKey, this.token);
        GetValue gv = (GetValue)v.getValue();
        if (gv != null && gv.getModifyIndex() > this.configVer) {
            this.configVer = gv.getModifyIndex();
            String configValue = gv.getDecodedValue();
            Properties keyValues = Utils.buildProperties((String)configValue);
            if (keyValues != null) {
                Solon.cfg().putAll((Map)keyValues);
            }
        }
        HashMap<String, String> updatedValues = new HashMap<String, String>();
        for (String key : this.watchKeys) {
            Response response = this.client.getKVValues(key, this.token);
            List getValues = (List)response.getValue();
            if (getValues == null) continue;
            for (GetValue value : getValues) {
                Long index = this.watchedIndex.get(value.getKey());
                if (index != null && index.longValue() == value.getModifyIndex()) continue;
                this.watchedIndex.put(value.getKey(), value.getModifyIndex());
                updatedValues.put(value.getKey(), value.getDecodedValue());
            }
        }
        if (updatedValues.size() > 0) {
            EventBus.push((Object)new ConsulKvUpdateEvent(updatedValues));
        }
    }
}

