/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.extend.consul.ConsulProps;
import org.noear.solon.cloud.extend.consul.service.CloudConfigServiceImp;
import org.noear.solon.cloud.extend.consul.service.CloudDiscoveryServiceImp;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.core.Plugin;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();

    public void start(SolonApp app) {
        long interval;
        TimerTask serviceImp;
        if (Utils.isEmpty((String)ConsulProps.instance.getServer())) {
            return;
        }
        if (ConsulProps.instance.getConfigEnable()) {
            serviceImp = new CloudConfigServiceImp();
            CloudManager.register((CloudConfigService)serviceImp);
            if (((CloudConfigServiceImp)serviceImp).getRefreshInterval() > 0L) {
                interval = ((CloudConfigServiceImp)serviceImp).getRefreshInterval();
                this.clientTimer.schedule(serviceImp, interval, interval);
            }
            CloudClient.configLoad((String)ConsulProps.instance.getConfigLoadGroup(), (String)ConsulProps.instance.getConfigLoadKey());
        }
        if (ConsulProps.instance.getDiscoveryEnable()) {
            serviceImp = new CloudDiscoveryServiceImp();
            CloudManager.register((CloudDiscoveryService)serviceImp);
            ((CloudDiscoveryServiceImp)serviceImp).run();
            if (((CloudDiscoveryServiceImp)serviceImp).getRefreshInterval() > 0L) {
                interval = ((CloudDiscoveryServiceImp)serviceImp).getRefreshInterval();
                this.clientTimer.schedule(serviceImp, interval, interval);
            }
            CloudClient.discoveryPush();
        }
    }

    public void stop() throws Throwable {
        if (this.clientTimer != null) {
            this.clientTimer.cancel();
        }
    }
}

