/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul.service;

import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.agent.model.Service;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.extend.consul.ConsulProps;
import org.noear.solon.cloud.extend.consul.detector.CpuDetector;
import org.noear.solon.cloud.extend.consul.detector.Detector;
import org.noear.solon.cloud.extend.consul.detector.DiskDetector;
import org.noear.solon.cloud.extend.consul.detector.JvmMemoryDetector;
import org.noear.solon.cloud.extend.consul.detector.MemoryDetector;
import org.noear.solon.cloud.extend.consul.detector.OsDetector;
import org.noear.solon.cloud.extend.consul.detector.QpsDetector;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.solon.core.event.EventBus;

public class CloudDiscoveryServiceImp
extends TimerTask
implements CloudDiscoveryService {
    private ConsulClient real;
    private String token;
    private long refreshInterval;
    private String healthCheckInterval;
    private String healthCheckPath;
    Map<String, Discovery> discoveryMap = new HashMap<String, Discovery>();
    private Map<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> observerMap = new HashMap<CloudDiscoveryHandler, CloudDiscoveryObserverEntity>();

    private void initClient() {
        String server = ConsulProps.instance.getDiscoveryServer();
        String[] ss = server.split(":");
        this.real = ss.length == 1 ? new ConsulClient(ss[0]) : new ConsulClient(ss[0], Integer.parseInt(ss[1]));
    }

    public CloudDiscoveryServiceImp() {
        this.token = ConsulProps.instance.getToken();
        this.refreshInterval = IntervalUtils.getInterval((String)ConsulProps.instance.getDiscoveryRefreshInterval("5s"));
        this.healthCheckInterval = ConsulProps.instance.getDiscoveryHealthCheckInterval("5s");
        this.healthCheckPath = ConsulProps.instance.getDiscoveryHealthCheckPath();
        this.initClient();
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void register(String group, Instance instance) {
        String[] ss = instance.address().split(":");
        String serviceId = instance.service() + "-" + instance.address();
        NewService newService = new NewService();
        newService.setId(serviceId);
        newService.setName(instance.service());
        newService.setAddress(ss[0]);
        newService.setPort(Integer.valueOf(Integer.parseInt(ss[1])));
        if (instance.tags() != null) {
            newService.setTags(instance.tags());
        }
        this.registerLocalCheck(instance, newService);
        this.real.agentServiceRegister(newService, this.token);
    }

    public void registerState(String group, Instance instance, boolean health) {
    }

    private void registerLocalCheck(Instance instance, NewService newService) {
        if (Utils.isNotEmpty((String)this.healthCheckInterval)) {
            HealthDetector detector = new HealthDetector();
            detector.startDetect(Solon.global());
            Solon.global().get(this.healthCheckPath, ctx -> {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("status", "OK");
                info.putAll(detector.getInfo());
                ctx.outputAsJson(GsonFactory.getGson().toJson(info));
            });
            String checkUrl = "http://" + instance.address();
            checkUrl = this.healthCheckPath.startsWith("/") ? checkUrl + this.healthCheckPath : checkUrl + "/" + this.healthCheckPath;
            NewService.Check check = new NewService.Check();
            check.setInterval(this.healthCheckInterval);
            check.setMethod("GET");
            check.setHttp(checkUrl);
            check.setDeregisterCriticalServiceAfter("30s");
            check.setTimeout("60s");
            newService.setCheck(check);
        }
    }

    public void deregister(String group, Instance instance) {
        String serviceId = instance.service() + "-" + instance.address();
        this.real.agentServiceDeregister(serviceId);
    }

    public Discovery find(String group, String service) {
        return this.discoveryMap.get(service);
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        this.observerMap.put(observer, new CloudDiscoveryObserverEntity(group, service, observer));
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    private void run0() {
        HashMap<String, Discovery> discoveryTmp = new HashMap<String, Discovery>();
        Response services = this.real.getAgentServices();
        for (Map.Entry kv : ((Map)services.getValue()).entrySet()) {
            Service service = (Service)kv.getValue();
            if (Utils.isEmpty((String)service.getAddress())) continue;
            String name = service.getService();
            Discovery discovery = (Discovery)discoveryTmp.get(name);
            if (discovery == null) {
                discovery = new Discovery(service.getService());
                discoveryTmp.put(name, discovery);
            }
            Instance instance = new Instance(service.getService(), service.getAddress() + ":" + service.getPort(), null).tagsAddAll((Collection)service.getTags()).metaPutAll(service.getMeta());
            discovery.instanceAdd(instance);
        }
        this.discoveryMap = discoveryTmp;
        this.noticeObservers();
    }

    private void noticeObservers() {
        for (Map.Entry<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> kv : this.observerMap.entrySet()) {
            CloudDiscoveryObserverEntity entity = kv.getValue();
            Discovery tmp = this.discoveryMap.get(entity.service);
            if (tmp == null) continue;
            entity.handler(tmp);
        }
    }

    static class HealthDetector {
        private static final Detector[] allDetectors = new Detector[]{new CpuDetector(), new JvmMemoryDetector(), new OsDetector(), new QpsDetector(), new MemoryDetector(), new DiskDetector()};
        Set<Detector> detectors = new HashSet<Detector>();

        public void startDetect(SolonApp app) {
            String detectorNamesStr = ConsulProps.instance.getDiscoveryHealthDetector();
            if (Utils.isEmpty((String)detectorNamesStr)) {
                return;
            }
            HashSet<String> detectorNames = new HashSet<String>(Arrays.asList(detectorNamesStr.split(",")));
            for (Detector detector : allDetectors) {
                if (!detectorNames.contains(detector.getName())) continue;
                this.detectors.add(detector);
                if (!(detector instanceof QpsDetector)) continue;
                ((QpsDetector)detector).toDetect(app);
            }
        }

        public Map<String, Object> getInfo() {
            HashMap<String, Object> info = new HashMap<String, Object>();
            for (Detector detector : this.detectors) {
                info.put(detector.getName(), detector.getInfo());
            }
            return info;
        }
    }
}

