/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul.service;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.extend.consul.ConsulProps;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.solon.core.event.EventBus;

public class CloudConfigServiceConsulImp
extends TimerTask
implements CloudConfigService {
    private static CloudConfigServiceConsulImp instance;
    private final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private ConsulClient real;
    private String token;
    private long refreshInterval;
    private Map<String, Config> configMap = new HashMap<String, Config>();
    private Map<CloudConfigHandler, CloudConfigObserverEntity> observerMap = new HashMap<CloudConfigHandler, CloudConfigObserverEntity>();

    public static synchronized CloudConfigServiceConsulImp getInstance() {
        if (instance == null) {
            instance = new CloudConfigServiceConsulImp();
        }
        return instance;
    }

    private void initClient() {
        String server = ConsulProps.instance.getConfigServer();
        String[] ss = server.split(":");
        this.real = ss.length == 1 ? new ConsulClient(ss[0]) : new ConsulClient(ss[0], Integer.parseInt(ss[1]));
    }

    private CloudConfigServiceConsulImp() {
        this.token = ConsulProps.instance.getToken();
        this.refreshInterval = IntervalUtils.getInterval((String)ConsulProps.instance.getConfigRefreshInterval("5s"));
        this.initClient();
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public Config pull(String group, String key) {
        String cfgKey;
        GetValue newV;
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        if ((newV = (GetValue)this.real.getKVValue(cfgKey = group + "/" + key, this.token).getValue()) != null) {
            Config oldV = this.configMap.get(cfgKey);
            if (oldV == null) {
                oldV = new Config(group, key, newV.getDecodedValue(), newV.getModifyIndex());
                this.configMap.put(cfgKey, oldV);
            } else if (newV.getModifyIndex() > oldV.version()) {
                oldV.value(newV.getDecodedValue(), newV.getModifyIndex());
            }
            return oldV;
        }
        return null;
    }

    public boolean push(String group, String key, String value) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        String cfgKey = group + "/" + key;
        return (Boolean)this.real.setKVValue(cfgKey, value).getValue();
    }

    public boolean remove(String group, String key) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        String cfgKey = group + "/" + key;
        this.real.deleteKVValue(cfgKey).getValue();
        return true;
    }

    public void attention(String group, String key, CloudConfigHandler observer) {
        if (this.observerMap.containsKey(observer)) {
            return;
        }
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        this.observerMap.put(observer, new CloudConfigObserverEntity(group, key, observer));
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    private void run0() {
        HashMap<String, Config> cfgTmp = new HashMap<String, Config>();
        for (Map.Entry<CloudConfigHandler, CloudConfigObserverEntity> kv : this.observerMap.entrySet()) {
            CloudConfigObserverEntity entity = kv.getValue();
            String cfgKey = entity.group + "/" + entity.key;
            GetValue newV = (GetValue)this.real.getKVValue(cfgKey, this.token).getValue();
            if (newV == null) continue;
            Config oldV = this.configMap.get(cfgKey);
            if (oldV == null) {
                oldV = new Config(entity.group, entity.key, newV.getDecodedValue(), newV.getModifyIndex());
                this.configMap.put(cfgKey, oldV);
                cfgTmp.put(cfgKey, oldV);
                continue;
            }
            if (newV.getModifyIndex() <= oldV.version()) continue;
            oldV.value(newV.getDecodedValue(), newV.getModifyIndex());
            cfgTmp.put(cfgKey, oldV);
        }
        for (Config cfg2 : cfgTmp.values()) {
            this.observerMap.forEach((k, v) -> {
                if (cfg2.group().equals(v.group) && cfg2.key().equals(v.key)) {
                    v.handler(cfg2);
                }
            });
        }
    }
}

