/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.extend.consul.ConsulProps;
import org.noear.solon.cloud.extend.consul.service.CloudConfigServiceConsulImp;
import org.noear.solon.cloud.extend.consul.service.CloudDiscoveryServiceConsulImp;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.core.Plugin;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();

    public void start(SolonApp app) {
        long interval;
        TimerTask serviceImp;
        if (Utils.isEmpty((String)ConsulProps.instance.getServer())) {
            return;
        }
        if (ConsulProps.instance.getConfigEnable()) {
            serviceImp = CloudConfigServiceConsulImp.getInstance();
            CloudManager.register((CloudConfigService)serviceImp);
            if (((CloudConfigServiceConsulImp)serviceImp).getRefreshInterval() > 0L) {
                interval = ((CloudConfigServiceConsulImp)serviceImp).getRefreshInterval();
                this.clientTimer.schedule(serviceImp, interval, interval);
            }
            CloudClient.configLoad((String)ConsulProps.instance.getConfigLoad());
            CloudClient.configLoad((String)ConsulProps.instance.getConfigLoadGroup(), (String)ConsulProps.instance.getConfigLoadKey());
        }
        if (ConsulProps.instance.getDiscoveryEnable()) {
            serviceImp = new CloudDiscoveryServiceConsulImp();
            CloudManager.register((CloudDiscoveryService)serviceImp);
            ((CloudDiscoveryServiceConsulImp)serviceImp).run();
            if (((CloudDiscoveryServiceConsulImp)serviceImp).getRefreshInterval() > 0L) {
                interval = ((CloudDiscoveryServiceConsulImp)serviceImp).getRefreshInterval();
                this.clientTimer.schedule(serviceImp, interval, interval);
            }
        }
    }

    public void prestop() throws Throwable {
        if (this.clientTimer != null) {
            this.clientTimer.cancel();
        }
    }
}

